package cn.quantgroup.xyqb.util;


import cn.quantgroup.kms.qiniu.QiniuAuth;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.DefaultPutRet;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

import java.io.ByteArrayInputStream;
import java.io.IOException;

/**
 * 七牛云上传工具类
 *
 * @author axq
 */
@Component
@Slf4j
public class QiNiuYunUtil {
    @Autowired
    private QiniuAuth qiniuAuth;
    @Autowired
    private UploadManager uploadManager;
//    @Autowired
//    private QiniuyunProperties qiniuyunProperties;

    private static final  String bucket ="kdsp";


    public static final String linkPrefix="https://kdspstatic.q-gp.com/";

    @Bean
    public UploadManager uploadManager() {
        //构造一个带指定 Region 对象的配置类
        com.qiniu.storage.Configuration cfg = new com.qiniu.storage.Configuration(Region.huanan());
        //...其他参数参考类注释
        return new UploadManager(cfg);
    }

    /**
     * 上传数据流
     *
     * @param uploadBytes 数据字节数组
     * @return
     */
    public String upload(byte[] uploadBytes, String contentType) throws Exception {
        //解析上传成功的结果
        ByteArrayInputStream byteInputStream = null;
        try {
            byteInputStream = new ByteArrayInputStream(uploadBytes);
            String upToken = qiniuAuth.getAuth().uploadToken(bucket);
            Response response = uploadManager.put(byteInputStream, null, upToken, null, contentType);
            //解析上传成功的结果
            DefaultPutRet putRet = new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            return linkPrefix + putRet.hash;
        } catch (Exception e) {
            log.error("七牛云上传文件异常", e);
            throw new Exception("上传数据流异常");
        } finally {
            if (byteInputStream != null) {
                try {
                    byteInputStream.close();
                } catch (IOException e) {
                    log.error("七牛云上传文件关闭流出现异常",e);
                }
            }
        }
    }


    public String overrideUpload(byte[] uploadBytes, String contentType, String fileName) throws Exception {
        //解析上传成功的结果
        ByteArrayInputStream byteInputStream = null;
        try {
            byteInputStream = new ByteArrayInputStream(uploadBytes);
            String upToken = qiniuAuth.getAuth().uploadToken(bucket, fileName);
            Response response = uploadManager.put(byteInputStream, fileName, upToken, null, contentType);
            //解析上传成功的结果
            DefaultPutRet putRet = new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            return linkPrefix + putRet.hash;
        } catch (Exception e) {
            log.error("七牛云上传文件异常，fileName:{}", fileName, e);
            throw new Exception("上传数据流异常");
        } finally {
            if (byteInputStream != null) {
                try {
                    byteInputStream.close();
                } catch (IOException e) {
                    log.error("overrideUpload七牛云上传文件关闭流出现异常",e);
                }
            }
        }
    }

    public String overrideUploadFileName(byte[] uploadBytes, String contentType, String fileName) throws Exception {
        //解析上传成功的结果
        ByteArrayInputStream byteInputStream = null;
        try {
            byteInputStream = new ByteArrayInputStream(uploadBytes);
            log.info("七牛云上传获取token，bucket:{},fileName:{}", bucket, fileName);
            String upToken = qiniuAuth.getAuth().uploadToken(bucket, fileName);
            log.info("七牛云上传参数，fileName:{},upToken:{},contentType:{}", fileName, upToken, contentType);

            Response response = uploadManager.put(byteInputStream, fileName, upToken, null, contentType);
            //解析上传成功的结果
            DefaultPutRet putRet = new Gson().fromJson(response.bodyString(), DefaultPutRet.class);
            log.info("七牛云上传结果，response:{},putRet:{}", JSONObject.toJSONString(response), JSONObject.toJSONString(putRet));
            return linkPrefix + putRet.key;
        } catch (Exception e) {
            log.error("七牛云上传文件异常，fileName:{}", fileName, e);
            throw new Exception("上传数据流异常");
        } finally {
            if (byteInputStream != null) {
                try {
                    byteInputStream.close();
                } catch (IOException e) {
                    log.error("overrideUploadFileName七牛云上传文件关闭流出现异常",e);
                }
            }
        }
    }

    /**
     * 上传本地文件
     *
     * @param localFilePath 本地文件路径
     * @param fileName      上传保存文件名
     * @return 文件外链
     */
    public String upload(String localFilePath, String fileName) {
        try {
            String upToken = qiniuAuth.getAuth().uploadToken(bucket);
            Response response = uploadManager.put(localFilePath, fileName, upToken);
            if (response.isOK()) {
                return linkPrefix + fileName;
            }
        } catch (QiniuException e) {
            log.error("七牛云上传本地文件:{} | 发生异常", localFilePath, e);
        }
        return null;
    }
}
