package cn.quantgroup.xyqb.service.mq.impl;

import cn.quantgroup.xyqb.service.mq.IRegisterMqService;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.io.Serializable;

/**
 * Created by xuran on 2017/9/7.
 */
@Slf4j
@Service("registerMqService")
public class IRegisterMqServiceImpl implements IRegisterMqService {

    @Autowired
    @Qualifier("registerRabbitTemplate")
    private RabbitTemplate registerRabTemplate;
    @Autowired
    @Qualifier("registerRabbitTemplate4Gdt")
    private RabbitTemplate registerRabbitTemplate4Gdt;

    @Autowired
    @Qualifier(value = "registerMqQueue")
    private Queue registerMqQueue;

    /**
     * 发送用登陆统计信息
     *
     * @param message 订单信息
     */
    @Override
    @Async
    public void send(Serializable message) {
        if (null == message) {
            log.error("广播用户注册消息不能为空");
        }
        log.info("广播用户注册消息,message={}", message);
        String msg = JSONObject.toJSONString(message);
        registerRabTemplate.convertAndSend(msg);
        log.info("广播用户注册消息,message={}", msg);
    }

    /**
     * 发送用登陆统计信息
     *
     * @param message 订单信息
     */
    @Override
    @Async
    public void send4Gdt(Serializable message) {
        if (null == message) {
            log.error("广点通用户注册消息不能为空");
        }
        log.info("广点通用户注册消息,message={}", message);
        String msg = JSONObject.toJSONString(message);
        registerRabbitTemplate4Gdt.convertAndSend(msg);
        log.info("广点通用户注册消息,message={}", msg);
    }

}
