package cn.quantgroup.xyqb.config.security;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.exception.PasswordErrorException;
import cn.quantgroup.xyqb.filter.AppAuthenticatedFilter;
import cn.quantgroup.xyqb.filter.Jr58AuthenticatedFilter;
import cn.quantgroup.xyqb.filter.SmsLoginAuthenticatedFilter;
import cn.quantgroup.xyqb.util.PasswordUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.StringUtils;

/**
 * Created by Miraculous on 15/7/4.
 */

@Configuration
@Order(SecurityProperties.ACCESS_OVERRIDE_ORDER)
public class SecurityConfig extends WebSecurityConfigurerAdapter {

    @Autowired
    @Qualifier("userDetailsService")
    private UserDetailsService userDetailsService;

    @Autowired
    private Jr58AuthenticatedFilter jr58AuthenticatedFilter;

    @Autowired
    private AppAuthenticatedFilter appAuthenticatedFilter;

    @Autowired
    private SmsLoginAuthenticatedFilter smsLoginAuthenticatedFilter;

    @Value("${xyqb.security.allowedRoutes}")
    private String allowedRoutes;

    @Override
    protected void configure(HttpSecurity http) throws Exception {
        String[] allowedRoutesArr = allowedRoutes.split(",");
        http
                .csrf().disable()
                .authorizeRequests()
                .antMatchers(allowedRoutesArr).permitAll()
                .anyRequest().authenticated()
                .and()
                .httpBasic()
                .authenticationEntryPoint(new RESTAuthenticationEntryPoint())
                .and()
                .addFilter(jr58AuthenticatedFilter)
                .addFilter(appAuthenticatedFilter)
                .addFilter(smsLoginAuthenticatedFilter)
                .logout();
    }

    @Override
    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(userDetailsService).passwordEncoder(new PasswordEncoder() {
            @Override
            public String encode(CharSequence rawPass) {
                return PasswordUtil.MD5(rawPass.toString().toLowerCase() + Constants.PASSWORD_SALT);
            }

            @Override
            public boolean matches(CharSequence rawPass, String password) {
                if (StringUtils.isEmpty(password)) {
                    throw new PasswordErrorException("密码错误");
                }
                if (password.equals(PasswordUtil.MD5(rawPass.toString().toLowerCase() + Constants.PASSWORD_SALT))) {
                    return true;
                }
                throw new PasswordErrorException("密码错误");
            }
        });
    }

    @Override
    public UserDetailsService userDetailsServiceBean() {
        return userDetailsService;
    }
}
