package cn.quantgroup.xyqb.config.security;

import cn.quantgroup.xyqb.exception.PasswordErrorException;
import cn.quantgroup.xyqb.exception.UserNotExistException;
import cn.quantgroup.xyqb.exception.VerificationCodeErrorException;
import cn.quantgroup.xyqb.model.JsonResult;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.apache.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;


/**
 * Created by Miraculous on 15/7/5.
 */
public class RESTAuthenticationEntryPoint implements AuthenticationEntryPoint {

    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException e) throws IOException, ServletException {
        JsonResult result = JsonResult.buildErrorStateResult("登录失败", null);
        if (e instanceof UserNotExistException || e.getCause() instanceof UserNotExistException) {
            result.setMsg("该用户名不存在，<br/>请重新输入或注册新账号。");
        } else if (e instanceof PasswordErrorException || e.getCause() instanceof PasswordErrorException) {
            result.setMsg("您的密码输入错误，<br/>请重新输入。");
        }

        response.setStatus(HttpStatus.SC_OK);
        response.setContentType("application/javascript; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.println(GSON.toJson(result));
        out.flush();
        out.close();
    }
}
