package cn.quantgroup.xyqb.service.model.impl;

import cn.quantgroup.xyqb.model.model.BlacklistMatchResult;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.model.IModelService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * Created by FrankChow on 15/12/16.
 */
@Service
public class ModelServiceImpl implements IModelService {

    private static final String BLACKLIST_URL_PATTERN =
            "%s/Model/openapi/checkBlack.json?appId=0001&userId=0001_001&timeunit=%s&token=%s&phone=%s";
    String TOKEN_PATTERN = "timeunit=%sappkey=wer123!@";
    @Value("${model.quantgroup.url}")
    private String modelUrlPrefix;
    @Autowired
    private IHttpService httpService;

    @Override
    public BlacklistMatchResult getBlacklistMatchResult(String phoneNo) {
        if (StringUtils.isEmpty(phoneNo)) {
            return null;
        }
        String url = buildBlacklistMatchUrl(phoneNo);
        String result = httpService.get(url);
        try {
            return JSONObject.parseObject(result, BlacklistMatchResult.class);
        } catch (Exception e) {
            return null;
        }
    }

    private String buildBlacklistMatchUrl(String phoneNo) {
        Long timeUnit = System.currentTimeMillis();
        String token = PasswordUtil.MD5(String.format(TOKEN_PATTERN, String.valueOf(timeUnit)));
        String url = String.format(BLACKLIST_URL_PATTERN, modelUrlPrefix, timeUnit, token, phoneNo);
        return url;
    }
}
