package cn.quantgroup.xyqb.controller;

import cn.quantgroup.xyqb.exception.PasswordErrorLimitException;
import cn.quantgroup.xyqb.exception.UserNotExistException;
import cn.quantgroup.xyqb.exception.VerificationCodeErrorException;
import cn.quantgroup.xyqb.exception.WechatRelateUserException;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.util.IPUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by Miraculous on 15/7/6.
 * 出现异常，进入这个handler。
 */
@ControllerAdvice
@RestController
public class ExceptionHandlingController implements IBaseController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionHandlingController.class);

    private static final JsonResult EXCEPTION_RESULT = new JsonResult("internal error", 500L, "");

    /**
     * 密码错误次数达到上限异常
     *
     * @param vce
     * @return
     */
    @ExceptionHandler(PasswordErrorLimitException.class)
    public JsonResult passwordErrorLimitException(PasswordErrorLimitException vce) {
        LOGGER.info("throw PasswordErrorLimitException,msg={},businessCode={}, clientIp={}", vce.getMessage(), 2L, IPUtil.getRemoteIP(getRequest()));
        return JsonResult.buildErrorStateResult(vce.getMessage(), null, 2L);
    }

    /**
     * 短信验证码错误或失效异常
     *
     * @param vce
     * @return
     */
    @ExceptionHandler(VerificationCodeErrorException.class)
    public JsonResult verificationCodeErrorException(VerificationCodeErrorException vce) {
        LOGGER.info("throw VerificationCodeErrorException,msg={},businessCode={}, clientIp={}", vce.getMessage(), 1L, IPUtil.getRemoteIP(getRequest()));
        return JsonResult.buildErrorStateResult(vce.getMessage(), null, 1L);
    }

    /**
     * 用户不存在异常
     *
     * @param unee
     * @return
     */
    @ExceptionHandler(UserNotExistException.class)
    @ResponseStatus(HttpStatus.UNAUTHORIZED)
    public JsonResult userNotExistException(UserNotExistException unee) {
        LOGGER.info("throw UserNotExistException,msg={},businessCode={},code={}", unee.getMessage(), 1L, 401L);
        return new JsonResult(unee.getMessage(), 401L, null);
    }

    /**
     * 微信关联异常
     *
     * @param wrue
     * @return
     */
    @ExceptionHandler(WechatRelateUserException.class)
    @ResponseStatus(HttpStatus.UNAUTHORIZED)
    public JsonResult wechatRelateUserException(WechatRelateUserException wrue) {
        LOGGER.info("throw WechatRelateUserException,msg={},businessCode={},code={}", wrue.getMessage(), 1L, 401L);
        return new JsonResult(wrue.getMessage(), 401L, null);
    }

    /**
     * 其他全局异常
     *
     * @param e
     * @return
     */
    @ExceptionHandler(Exception.class)
    public JsonResult exceptionOccurs(Exception e) {
        HttpServletRequest request = getRequest();
        String uri = request.getRequestURI();
        String registerFrom = request.getParameter("registerFrom");
        LOGGER.error("[exception][global_exception]接口异常 URI:{}, registerFrom:{},error={}", uri, registerFrom, e);
        return EXCEPTION_RESULT;
    }
}
