package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserInfoEntity;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.repository.IUserInfoRepository;
import cn.quantgroup.xyqb.util.ValidationUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Slf4j
@Component
public class DetailRegisteredEventListener implements ApplicationListener<RegisterEvent> {
    @Resource
    private IUserInfoRepository userInfoRepository;

    @Override
    public void onApplicationEvent(RegisterEvent event) {
        UserRegisterParam userRegisterParam = event.getUserRegisterParam();
        User user = userRegisterParam.getUser();

        if (StringUtils.isAnyBlank(userRegisterParam.getName()) ||
                !ValidationUtil.validateChinese(userRegisterParam.getName())) {
            return;
        }
        String phoneNo = userRegisterParam.getPhoneNo();
        String name = userRegisterParam.getName();
        UserInfoEntity userDetail = new UserInfoEntity();
        userDetail.setPhoneNo(phoneNo);
        userDetail.setName(name);
        userDetail.setUserId(user.getId());
        log.info("DetailRegisteredEventListener saveUserDetail, userId:{}, phoneNo:{}, name:{}", user.getId(), phoneNo, name);
        userInfoRepository.save(userDetail);
    }
}
