package cn.quantgroup.xyqb.aspect.log;

import javassist.ClassClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.w3c.dom.Attr;

import java.util.Arrays;
import java.util.UUID;

/**
 * Created by 11 on 2017/4/20.
 */
@Aspect
@Configuration
public class ParamLogAdvice {

    private Logger LOGGER = LoggerFactory.getLogger(ParamLogAdvice.class);

    @Pointcut("execution(* cn.quantgroup.xyqb.controller.external.user.InnerController.*(..))")
    public void logPointCut(){}

    @Around("logPointCut()")
    public Object printMethodParam(ProceedingJoinPoint pjp) {
        Object obj = null;
        try {
            obj = pjp.proceed();
        } catch (Throwable t) {
            t.printStackTrace();
        }
        Object[] params = pjp.getArgs();
        String methodName = pjp.getSignature().getName();
        String[] paramNames = null;
        try {
            paramNames = getFieldsName(pjp.getTarget().getClass(), pjp.getTarget().getClass().getName(), methodName);
        } catch (Exception e) {
            e.printStackTrace();
        }
        StringBuffer buffer = new StringBuffer();
        LOGGER.info("invoke method:{}, method params:{}", pjp.getSignature().getName(), Arrays.toString(params));
        if(null != paramNames) {
            for(int i = 0; i < paramNames.length; i ++) {
                buffer.append(paramNames[i]).append(":").append(params[i]).append(" ");
            }
            String logInfo = buffer.toString().substring(0, buffer.toString().length() - 1);
            LOGGER.info("调用方法,方法名:{} , 方法参数:{}", methodName, logInfo);
        }
        return obj;
    }

    private static String[] getFieldsName(Class cls, String clazzName, String methodName) throws NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        ClassClassPath classPath = new ClassClassPath(cls);
        pool.insertClassPath(classPath);

        CtClass cc = pool.get(clazzName);
        CtMethod cm = cc.getDeclaredMethod(methodName);
        MethodInfo methodInfo = cm.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        LocalVariableAttribute attr = (LocalVariableAttribute) codeAttribute.getAttribute(LocalVariableAttribute.tag);
        if (attr == null) {
            return null;
        }
        String[] paramNames = new String[cm.getParameterTypes().length];
        int pos = Modifier.isStatic(cm.getModifiers()) ? 0 : 1;
        for (int i = 0; i < paramNames.length; i++){
            paramNames[i] = attr.variableName(i + pos);
        }
        return paramNames;
    }
}
