package cn.quantgroup.xyqb.model.session;

import cn.quantgroup.tool.util.SpringUtil;
import cn.quantgroup.xyqb.config.http.Timestamp2LongConverter;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.LoginProperties;
import cn.quantgroup.xyqb.repository.IUserRepository;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.sql.Timestamp;
import java.util.Map;

/**
 * Created by Miraculous on 2016/12/28.
 */
@Data
@NoArgsConstructor
public class SessionValue {
    private User user;
    private Map<String, String> values;

    @JSONField(serializeUsing = Timestamp2LongConverter.class)
    private Timestamp createdAt;
    @JSONField(serializeUsing = Timestamp2LongConverter.class)
    private Timestamp lastAccessTime;

    private LoginProperties loginProperties;

    public User getUser() {
        IUserRepository userRepository = SpringUtil.getBean(IUserRepository.class);
        User one = userRepository.getOne(user.getId());
        return one;
    }
}
