package cn.quantgroup.xyqb.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/6/22 11:01
 * @description：过滤地址特殊符号
 * @modified By：
 * @version: 1.0
 */
public class AddressFilter {
    //移动运营商开头
    private static final List<String> MOBILE = Lists.newArrayList("134", "135", "136", "137", "138", "139", "147", "150", "151", "152", "157", "158", "159", "178", "182", "183", "184", "187", "188", "198");
    //电信
    private static final List<String> TELECOM = Lists.newArrayList("133", "153", "180", "181", "189", "177");
    //联通
    private static final List<String> UNICOM = Lists.newArrayList("130", "131", "132", "145", "155", "156", "176", "185", "186");
    //运营商
    private static final Map<List<String>, String> OPERATO_MAP = Maps.newConcurrentMap();
    //联通后缀
    private static final String UNICOM_SUFFIX = "@wo.cn";

    private static final List<PatternEntry> PATTERN_LIST = Lists.newArrayList();
    //邮箱正则
    private static Pattern EMAIL_PATTERN = Pattern.compile("^[A-Za-z0-9]+([._\\-]*[A-Za-z0-9])*@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$");

    //首尾中文
    private static Pattern CHINA_PATTERN = Pattern.compile("^[\u4e00-\u9fa5]+|[\u4e00-\u9fa5]+$");

    static {
        synchronized (AddressFilter.class) {
            if (PATTERN_LIST.size() == 0) {

                PATTERN_LIST.add(new PatternEntry("|", ""));

                OPERATO_MAP.put(MOBILE, "@139.com");
                OPERATO_MAP.put(TELECOM, "@189.cn");
//             OPERATO_MAP.put(UNICOM,"@wo.cn");
            }

        }

    }



    /**
     * 是否包含特殊字符
     *
     * @param address
     * @return
     */
    public static boolean isIncSpeChar(String address) {
        if (!StringUtils.isNotEmpty(address)) {
            return false;
        }
        for (PatternEntry pattern : PATTERN_LIST) {
            if (address.contains(pattern.getTarget())) {
                return true;
            }
        }
        return false;
    }

    /**
     * 过滤特殊字符
     *
     * @param address
     * @return
     */
    public static String filterAddress(String address) {

        if (!StringUtils.isNotEmpty(address)) {
            return address;
        }

        for (PatternEntry pattern : PATTERN_LIST) {
            address = StringUtils.replace(address, pattern.getTarget(), pattern.getReplaceMent());
        }

        return address;
    }


    //替换email
    public static String getEmail(String phone,String email) {
        //去掉所有的空白
        if(null != email){
            email = email.replaceAll("\\s","");
            Matcher matcher = CHINA_PATTERN.matcher(email);
            if(matcher.find()){
                email =  matcher.replaceAll("");
            }
        }

        if(isEmail(email)){
            return email;
        }
        if( null == phone){
            return null;
        }
        Set<Map.Entry<List<String>, String>> entries = OPERATO_MAP.entrySet();
        for (Map.Entry<List<String>, String> entry : entries) {
            boolean contains = entry.getKey().contains(phone.substring(0, 3));
            if(contains){
                return phone.concat(entry.getValue());
            }
        }
        return phone.concat(UNICOM_SUFFIX);
    }
    //校验是否是邮箱
    public static boolean isEmail(String email){
        if(null == email){
            return false;
        }
        Matcher matcher = EMAIL_PATTERN.matcher(email);
        return matcher.matches();
    }

    @Getter
    @Setter
    @AllArgsConstructor
    public static class PatternEntry {
        private String target;
        private String replaceMent;
    }

    public static void main(String[] args) {
        String email = getEmail("18518759303", "啊412763575@qq.com董建华");
        System.out.println(email);
    }
}
