package cn.quantgroup.xyqb.service.register.handler.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserBtRegister;
import cn.quantgroup.xyqb.model.UserRegisterParam;
import cn.quantgroup.xyqb.service.register.handler.AbstractUserRegisterHandler;
import cn.quantgroup.xyqb.service.user.IUserBtRegisterService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import java.sql.Timestamp;
import java.util.Objects;

/**
 * Created by liqing on 2017/12/4 0004.
 * 用户注册 - 白条
 * 失败影响注册流程
 */
@Component("btUserRegisterHandler")
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@Slf4j
public class BtUserRegisterHandler extends AbstractUserRegisterHandler {

    @Autowired
    private IUserBtRegisterService userBtRegisterService;

    @Override
    public User handleRegister(UserRegisterParam userRegisterParam) {
        Long channelId = userRegisterParam.getChannelId();
        User user = userRegisterParam.getUser();
        Long btRegisterChannelId = userRegisterParam.getBtRegisterChannelId();
        if (!Objects.isNull(user) && Objects.equals(channelId, 222L)) {
            UserBtRegister userBtRegister = new UserBtRegister();
            userBtRegister.setUserId(user.getId());
            if (null == btRegisterChannelId) {
                userBtRegister.setRegisterBtMerchantId(0L);
            } else {
                userBtRegister.setRegisterBtMerchantId(btRegisterChannelId);
            }
            userBtRegister.setIsActive(true);
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            userBtRegister.setCreatedAt(currentTime);
            userBtRegister.setUpdatedAt(currentTime);
            userBtRegisterService.save(userBtRegister);
        }
        if (!Objects.isNull(successor)) {
            return successor.handleRegister(userRegisterParam);
        }
        return userRegisterParam.getUser();
    }

}
