package cn.quantgroup.xyqb.controller.risk;

import cn.quantgroup.xyqb.entity.enums.KeyType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.risk.LoginRiskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/12/14 15:02
 * @description：登录白名单控制器
 * @modified By：
 * @version: 1.0
 */
@Slf4j
@RestController
@RequestMapping("/login/risk")
public class LoginWhiteListController {
    @Resource
    private LoginRiskService loginRiskService;

    @RequestMapping(value = "/login/risk", method = RequestMethod.POST)
    public JsonResult addWhiteList(String val, KeyType type) {
        log.info("添加用户白名单val:{},type:{}", val, type);
        if (null == val || null == type) {
            return JsonResult.buildErrorStateResult("参数有误", null);
        }
        loginRiskService.addWhiteList(val, type);
        return JsonResult.buildSuccessResult();
    }
}
 .