package common;

import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

import cn.quantgroup.xyqb.util.ValidationUtil;

@Slf4j
@RunWith(JUnit4.class)
public class TestValidationUtil {

    public static void main(String[] args){
        String[][] contacts = {
                {"18589336973","刘䶮"},
                {"13198898119","张鑫鑫"},
                {"16620800072","许慧梓"},
                {"1508964071 ","1508964071 "},
                {"16603429800","张泽浩"},
                {"17393151197","李小林？"},
                {"18721920553","王正\u202D"}};
        for(String[] ctc : contacts) {
            log.info("phoneNo:[{}][{}],name:[{}][{}],name-trim:[{}][{}]",
                    ctc[0],ValidationUtil.validatePhoneNo(ctc[0]),
                    ctc[1], ValidationUtil.validateChinese(ctc[1]),
                    ctc[1].trim(),ValidationUtil.validateChinese(ctc[1].trim()));
        }
    }

    @Test
    public void testString() {
        assert true;
    }

}
