package cn.quantgroup.xyqb.controller.v2;

import cn.quantgroup.xyqb.controller.req.v2.SMSReq;
import cn.quantgroup.xyqb.controller.req.v2.SMSVerifyReq;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.SMSCodeBean;
import cn.quantgroup.xyqb.service.v2.VerificationCodeContext;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@RestController
@RequestMapping("/v2/sms")
public class SMSV2controller {

    private final VerificationCodeContext verificationCodeContext;

    public SMSV2controller(VerificationCodeContext verificationCodeContext) {
        this.verificationCodeContext = verificationCodeContext;
    }

    /**
     * 统一获取短信验证码
     *
     * @return JsonResult<SMSCodeBean>
     * @see <a href="http://yapi.quantgroups.com/project/17/interface/api/65709">统一获取短信验证码</a>
     */
    @PostMapping("/code")
    public JsonResult<SMSCodeBean> getCode(@Valid @RequestBody SMSReq smsReq) {
        if (smsReq.getCodeLength() != null && (smsReq.getCodeLength() < 4 || smsReq.getCodeLength() > 10)) {
            throw new BizException(BizExceptionEnum.ERROR_PARAM, "密码长度只能在4到10位之间");
        }
        if(smsReq.getSceneType()!=null &&(smsReq.getSceneType()<0||smsReq.getSceneType()>2)){
            throw new BizException(BizExceptionEnum.ERROR_PARAM, "请输入有效的场景值");
        }

        return JsonResult.buildSuccessResultGeneric(verificationCodeContext.send(smsReq));
    }

    /**
     * 统一验证短信验证码
     *
     * @return JsonResult<Boolean>
     * @see <a href="http://yapi.quantgroups.com/project/17/interface/api/65829">...</a>
     */
    @PostMapping("/verify")
    public JsonResult<Boolean> verify(@Valid @RequestBody SMSVerifyReq smsVerifyReq) {

        return JsonResult.buildSuccessResultGeneric(verificationCodeContext.verify(smsVerifyReq));
    }


}
