package cn.quantgroup.xyqb;


/**
 * Created by Miraculous on 15/7/5.
 */
public interface Constants {

    // zero fill with 4 chars...
    String ZERO_FILL_TEMPLATE = "%04d";
    String IMAGE_CAPTCHA_KEY = "img_captcha:";
    String REDIS_CAPTCHA_KEY = "auth:";
    String REDIS_PREFIX_VERIFICATION_CODE = "verificationCode_";
    //新版短信验证码计数
    String REDIS_SMS_IP_COUNT = "SMS_Ip_verification_code_count:";
    String REDIS_SMS_CODE_COUNT = "SMS_Phone_verification_code_count:";
    String REDIS_SMS_DEVICE_COUNT = "SMS_Device_verification_code_count:";
    //新版语音验证码计数
    String REDIS_VOICE_IP_COUNT = "Voice_Ip_verification_code_count:";
    String REDIS_VOICE_CODE_COUNT = "Voice_Phone_verification_code_count:";
    String REDIS_VOICE_DEVICE_COUNT = "Voice_Device_verification_code_count:";

    String REDIS_VERIFICATION_COUNT = "verification_code_count:";
    Long Image_Need_Count = 3L;
    Long VERIFICATION_CODE_FINITE_COUNT = 3L;

    String X_AUTH_TOKEN = "x-auth-token";
    int TOKEN_LENGTH = 36;
    int THOUSAND_SECOND = 1000;
    int MILLIS_PER_SECOND = 1000;
    int MILLIS_OF_TEN_SECOND = 10000;
    /** 垃圾，前辈竟然用这个办法来识别UUID */
    int UUID_MIN_LENGTH = 10;
    String CHECK_FAIL = "fail";
    String SPLIT_CHAR = ":";
    String TOKEN_MASTER = "*";
    String PASSWORDD_HEADER = "Basic ";
    int AUTHORIZE_HEADER_SIZE = 2;
    String PAGE_NEXT_KEY_XYQB = "xyqb";
    /**
     * 登录账号/手机号参数名
     */
    String PHONE_NO = "phoneNo";
    /**
     * 微信标识参数名
     */
    String WECHAT_OPEN_ID = "wechat_open_id";
    String PASSWORD = "password";

    // -- Start -- IPV4安全策略常量组
    /**
     * 账密不匹配错误 - 按账号计数
     */
    String REDIS_PASSWORD_ERROR_COUNT = "password_error_count:";
    /**
     * 账密不匹配错误 - 按IP计数
     */
    String REDIS_PASSWORD_ERROR_COUNT_FOR_IPV4 = "password_error_count_4_ipv4:";
    /**
     * 账密匹配成功 - 按IP计数
     */
    String REDIS_PASSWORD_SUCCESS_COUNT_FOR_IPV4 = "password_success_count_4_ipv4:";
    /**
     * 账密安全策略 - 白名单
     */
    String IPV4_LOCK_WHITE = "lock_ipv4:white:";
    /**
     * 账密安全策略 - 黑名单
     */
    String IPV4_LOCK_BLACK = "lock_ipv4:black:";
    /**
     * 账密安全策略 - 锁机制自定义参数 - 锁定分钟数
     */
    String IPV4_LOCK_MINUTES_REDIS = "lock_ipv4:minutes:";
    /**
     * 账密安全策略 - 锁机制自定义参数 - 锁开关阈值
     */
    String IPV4_LOCK_ON_COUNTS_REDIS = "lock_ipv4:on_counts:";
    /**
     * 账密安全策略 - 锁机制 - IPV4锁
     */
    String IPV4_LOCK = "lock_ipv4:";
    /**
     * 账密不匹配错误 - 锁机制默认参数 - 锁定分钟数
     */
    Long IPV4_FAILED_LOCK_MINUTES = 3 * 60L;
    /**
     * 账密不匹配错误 - 锁机制默认参数 - 计数周期
     */
    Long IPV4_FAILED_COUNT_MINUTES = 1L;
    /**
     * 账密不匹配错误 - 锁机制默认参数 - 锁开关阈值
     */
    Long IPV4_LOCK_ON_FAILED_COUNTS = 60L;
    /**
     * 账密匹配成功 - 锁机制默认参数 - 锁定分钟数
     */
    Long IPV4_SUCCESS_LOCK_MINUTES = 30L;
    /**
     * 账密匹配成功 - 锁机制默认参数 - 计数周期
     */
    Long IPV4_SUCCESS_COUNT_MINUTES = 60L;
    /**
     * 账密匹配成功 - 锁机制默认参数 - 锁开关阈值
     */
    Long IPV4_LOCK_ON_SUCCESS_COUNTS = 40L;
    /**
     * 安全策略参数设置 - 秘钥 - 口令
     */
    String CLEAR_LOCK_FOR_IPV4 = "x-clear-lock-11241842-y";
    /**
     * 安全策略参数设置 - 私钥
     */
    String CLEAR_LOCK_FOR_IPV4_KEY = "lhp.family.dwy.sjs.yym.cxy.cpg";
    // -- End -- IPV4安全策略常量组
    /**
     * redis中token的key值前缀
     */
    String SESSION_PREFIX = "spring:session:sessions:";

    /**
     * 默认随机密码长度
     */
    int RANDOM_PWD_LEN = 15;
    /** 标准大陆身份证号长度 */
    int IDNO_LENGTH = 18;

    interface Channel {
        long BAITIAO = 222L;
        String LKB_CODE = "0002";    // 量化派channnel_code
        long WECHAT = 198L;
    }

    interface Session {
        String USER_SESSION_CACHE = "user:session:";
        String USER_SESSION_ID_CACHE = "userid-sessionvalue:cache:";
        String USER_SESSION_KEY_SET = "userid-keys:set:";
        Long ONE_DAY = 24 * 60 * 60L;
    }

    interface UserAvatar {
        String AVATAR_DEFAULT = "https://avatar.xyqb.com/default_avatar.png";
    }

    String AES_KEY = "ScnmRBhuQpo9kBdn";

    // -- Start -- 验证码常量组
    int GT_CAPTCHA_VALIDATE_SUCCESS = 1;
    String GT_UNIQUE_KEY = "uniqueKey";
    String FN_GEETEST_CHALLENGE = "geetest_challenge";
    String FN_GEETEST_VALIDATE = "geetest_validate";
    String FN_GEETEST_SECCODE = "geetest_seccode";
    String QG_CAPTCHA_ID = "captchaId";
    String QG_CAPTCHA_VALUE = "captchaValue";
    /**
     * 客户端类型参数名
     */
    String CLIENT_TYPE = "clientType";
    /**
     * 验证类型请求参数名
     */
    String VERIFY_PARAM = "verifyType";
    /**
     * 验证类型 - 极验
     */
    String VERIFY_TYPE_GT = "gt";
    /**
     * 验证类型 - 量化派图形验证
     */
    String VERIFY_TYPE_QG = "qg";
    // -- End -- 验证码常量组
}
