package cn.quantgroup.xyqb.repository;


import cn.quantgroup.xyqb.entity.WechatUserInfo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import static org.springframework.transaction.annotation.Propagation.MANDATORY;

/**
 * Created by 11 on 2017/1/18.
 */
public interface IWeChatUserRepository extends JpaRepository<WechatUserInfo, Long> {
    WechatUserInfo findByOpenId(String openId);

    WechatUserInfo findByPhoneNo(String phoneNo);

    WechatUserInfo findByUserId(Long userId);

    long countByOpenId(String openId);

    /**
     * 解除关联关系 -- 当前用户的已关联微信
     * 注：应用服务的JDBC数据源连接，无delete权限
     *
     * @param userId
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set user_id=null,phone_no='*' where user_id=?1", nativeQuery = true)
    int dissociateByUserId(Long userId);

    /**
     * 关联用户
     *
     * @param userId  - 用户标识
     * @param phoneNo
     * @param openId  - 微信标识
     * @return 记录更新行数
     */
    @Transactional(rollbackFor = Exception.class)
    @Modifying
    @Query(value = "update wechat_userinfo set user_id=?1,phone_no=?2 where open_id=?3 and user_id is null", nativeQuery = true)
    int relateUser(Long userId, String phoneNo, String openId);

    /**
     * 解除关联关系 -- 包括：1、当前微信旧的关联用户；2、当前用户旧的关联微信
     * 强制事务
     *
     * @param openId - 微信标识
     * @param userId - 用户标识
     * @return 记录更新行数
     */
    @Transactional(propagation = MANDATORY)
    @Modifying
    @Query(value = "update wechat_userinfo set user_id=null,phone_no='*' where open_id=?1 or user_id=?2", nativeQuery = true)
    int dissociateUser(String openId, Long userId);
}
