package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import lombok.Data;

@Data
public class UserBean {
    private Long userId;
    private String openId;
    private String appId;
    private String unionId;
    private String phoneNo;

    private Long registeredFrom;

    private String uuid;

    private Boolean enable;
    private Integer tenantId;


    public static UserBean from(User user, WechatUserInfo wechatUserInfo) {
        UserBean userBean = new UserBean();
        userBean.setUserId(user.getId());
        userBean.setPhoneNo(userBean.getPhoneNo());
        userBean.setRegisteredFrom(user.getRegisteredFrom());
        userBean.setUuid(userBean.getUuid());
        userBean.setEnable(user.getEnable());
        userBean.setTenantId(user.getTenantId());
        if (wechatUserInfo != null) {
            userBean.setOpenId(wechatUserInfo.getOpenId());
            userBean.setUnionId(wechatUserInfo.getUnionId());
            userBean.setAppId(wechatUserInfo.getAppId());
        }
        return userBean;
    }
}
