package cn.quantgroup.xyqb.session;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.session.SessionValue;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by Miraculous on 2016/12/29.
 */
public class XyqbSessionContextHolder {

  private static final ThreadLocal<SessionStruct> threadSession = new ThreadLocal<>();
  private static final Logger LOGGER = LoggerFactory.getLogger(XyqbSessionContextHolder.class);
  public static RedisTemplate<String, String> redisTemplate = null;

  public static SessionStruct getXSession() {
    if (threadSession.get() != null) {
      return threadSession.get();
    }
    HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    String token = request.getHeader("x-auth-token");
    if (token == null || token.length() != 36) {
      return null;
    }
    String result = redisTemplate.opsForValue().get(Constants.Session.USER_SESSION_CACHE + token);
    if (StringUtils.isEmpty(result)) {
      return null;
    }
    try {
      SessionValue values = JSON.parseObject(result, SessionValue.class);

      if (values == null) {
        return null;
      }
      SessionStruct sessionStruct = new SessionStruct();
      sessionStruct.setSid(token);
      sessionStruct.setValues(values);
      threadSession.set(sessionStruct);
      return sessionStruct;
    } catch (Exception ex) {
      LOGGER.error("序列化session出错", ex);
      return null;
    }
  }

  public static void releaseSession() {
    threadSession.remove();
  }
}
