package cn.quantgroup.xyqb.controller;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.repository.IUserRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

/**
 * 测试类
 *
 * @author killer
 * @date 2022年01月04日
 **/
@RestController
@RequestMapping("/v1/test")
@RequiredArgsConstructor
public class TestController {

    private final IUserRepository userRepository;

    @PostMapping(value = "/save/user")
    public JsonResult<?> saveUser(@RequestBody User user) {
        User result = userRepository.save(user);
        return JsonResult.buildSuccessResult("保存成功", result);
    }

    @GetMapping(value = "/query/user/{id}")
    public JsonResult<?> saveUser(@PathVariable("id") Long id) {
        User result = userRepository.findById(id);
        return JsonResult.buildSuccessResult("查询成功", result);
    }
}
