package cn.quantgroup.xyqb.entity;


import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by 11 on 2016/12/30.
 */
@Data
@Entity
@Table(name = "address", uniqueConstraints = @UniqueConstraint(columnNames = "user_id"))
public class Address extends BaseEntity implements Serializable {

    private static final long serialVersionUID = -1L;

    @Column(name = "user_id")
    private Long userId;
    @Column(name = "province_code")
    private Long provinceCode;
    @Column(name = "province")
    private String province;
    @Column(name = "city_code")
    private Long cityCode;
    @Column(name = "city")
    private String city;
    @Column(name = "district_code")
    private Long districtCode;
    @Column(name = "district")
    private String district;
    @Column(name = "address")
    private String address;


    public String toString() {
        return province + "(省)" + city + "(市)" + district + "(区/县)" + address;
    }
}
