package cn.quantgroup.xyqb.controller.middleoffice.common.image;

import cn.quantgroup.xyqb.util.ApplicationContextHolder;

import java.util.HashMap;
import java.util.Map;

public class ImageVerifyStrategyFactory {
    private static final Map<ImageVerifyTypeEnum, IImageVerifyStrategy> strategiesMap = new HashMap<>();

    static {
        //cache
        Map<String, IImageVerifyStrategy> beansOfType = ApplicationContextHolder.getBeansOfType(IImageVerifyStrategy.class);
        beansOfType.values().forEach(strategy -> strategiesMap.put(strategy.strategyName(), strategy));
    }

    public static IImageVerifyStrategy get(ImageVerifyTypeEnum verifyTypeEnum) {
        return strategiesMap.get(verifyTypeEnum);
    }


}
