package cn.quantgroup.xyqb.service.captcha;

import cn.quantgroup.xyqb.model.ClientType;

import java.util.Map;

/**
 * @author xufei on 2018/1/30.
 */
public interface IGeetestCaptchaService {

    /**
     * 获取极验验证码
     *
     * @param markId 用户标识
     * @param remoteIp 请求终端真实IP
     * @param clientType 请求终端类型
     * @return 获取失败返回null
     */
    Map<String, String> fetchGeetestCaptcha(String markId, String remoteIp, ClientType clientType);


    /**
     * 二次验证
     *
     * @param markId 用户标识
     * @param remoteIp 请求终端真实IP
     * @param clientType 请求终端类型
     * @param challenge
     * @param validate
     * @param seccode
     * @return
     */
    boolean validGeetestCaptcha(String markId, String remoteIp, ClientType clientType, String challenge, String validate, String seccode);

}
