package cn.quantgroup.xyqb.controller.modifyphoneno.req;

import cn.quantgroup.xyqb.controller.req.Page;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

/**
 * Date: 2019/11/5
 * Time: 下午4:02
 *
 * @author: yangrui
 */
@Data
public class ModifyPhoneNoQueryReq extends Page {

    /**
     * 申请人旧手机号
     */
    @ApiModelProperty("申请人旧手机号")
    private String phoneNo;

    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private String startAt;

    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private String endAt;

    /**
     * 申请状态 0处理中; 1修改完成; 2不允许修改;
     */
    @ApiModelProperty("申请状态 0处理中; 1修改完成; 2不允许修改;")
    @Range(min = 0, max = 2, message = "申请状态不合法。")
    private Integer applyStatus;

    /**
     * 处理状态 0待人工处理 1待用户反馈结果 2已反馈
     */
    @ApiModelProperty("处理状态 0待人工处理; 1待用户反馈结果; 2已反馈")
    @Range(min = 0, max = 2, message = "处理状态不合法。")
    private Integer processingStatus;
}
