package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.service.user.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class CacheEvictPhoneNoUpdateEventListener implements ApplicationListener<PhoneNoUpdateEvent> {

    @Autowired
    private IUserService userService;

    @Override
    public void onApplicationEvent(PhoneNoUpdateEvent event) {
        String oldPhoneNo = event.getOldPhoneNo();
        User user = event.getUser();
        userService.userCacheEvict(user.getUuid(), oldPhoneNo);
        //todo session 处理

    }
}
