package cn.quantgroup.xyqb.config.mq;

import cn.quantgroup.tech.brave.service.ITechRabbitBuilder;
import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.annotation.Resource;

/**
 * //马甲包 xuran
 */
@Primary
@Configuration
public class LoanVestMQConfig {
    @Value("${loanvest.rabbitmq.queue}")
    private String queueName;
    @Value("${loanvest.rabbitmq.exchange}")
    private String loanVestExchange;

    @Value("${loanvest.rabbitmq.connection.host}")
    private String host;
    @Value("${loanvest.rabbitmq.connection.port}")
    private Integer port;
    @Value("${loanvest.rabbitmq.connection.user}")
    private String user;
    @Value("${loanvest.rabbitmq.connection.password}")
    private String password;
    @Value("${loanvest.rabbitmq.connection.virtual-host}")
    private String virtualHost;

    @Resource
    private ITechRabbitBuilder techRabbitBuilder;

    @Primary
    @Bean(name = "vestFactory")
    public ConnectionFactory vestFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(host, port);
        connectionFactory.setChannelCacheSize(1024);
        connectionFactory.setCacheMode(CachingConnectionFactory.CacheMode.CONNECTION);
        connectionFactory.setChannelCacheSize(180 * 1000);
        connectionFactory.setConnectionCacheSize(1024);
        connectionFactory.setUsername(user);
        connectionFactory.setPassword(password);
        connectionFactory.setVirtualHost(virtualHost);
        connectionFactory.setPublisherReturns(false);
        connectionFactory.setPublisherConfirms(false);
        return connectionFactory;
    }

    @Primary
    @Bean(name = "loanVestAmqpAdmin")
    public AmqpAdmin loanVestAdmin(@Qualifier("vestFactory") ConnectionFactory vestFactory) {
        return new RabbitAdmin(vestFactory);
    }

    @Primary
    @Bean(name = "loanVestExchange")
    public FanoutExchange loanVestExchange() {
        return new FanoutExchange(loanVestExchange);
    }

    @Primary
    @Bean(name = "loanVestQueue")
    public Queue loanVestQueue() {
        return new Queue(queueName);
    }

    @Primary
    @Bean(name = "loanVestBinding")
    public Binding bindingLoanVest(@Qualifier("loanVestAmqpAdmin") AmqpAdmin loanVestAdmin, @Qualifier("loanVestQueue") Queue loanVestQueue, @Qualifier("loanVestExchange") FanoutExchange loanVestExchange) {
        Binding binding = BindingBuilder.bind(loanVestQueue).to(loanVestExchange);
        loanVestAdmin.declareBinding(binding);
        return binding;
    }

    @Primary
    @Bean(name = "rabbitTemplate")
    public RabbitTemplate loanVestTemplate(@Qualifier("vestFactory") ConnectionFactory vestFactory) {
        RabbitTemplate template = techRabbitBuilder.createRabbitTemplate(vestFactory);
        template.setExchange(loanVestExchange);
        return template;
    }
}
