package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.UserInfoEntity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import lombok.Data;

import javax.persistence.Column;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Describe:
 * @Created by tangfeng 2023/7/20 20:58
 */
@Data
public class UserInfoEntityBean extends UserInfoEntity {

    /**
     * 头像历史版本兼容
     */
    private String avatar;

    /**
     * 昵称历史版本兼容
     */
    private String nick;

    public static UserInfoEntityBean covert(UserInfoEntity bean) {
        if (bean == null) {
            return null;
        }
        UserInfoEntityBean userInfoEntityBean = JSONObject.parseObject(JSON.toJSONString(bean), UserInfoEntityBean.class);
        userInfoEntityBean.setAvatar(bean.getPhoto());
        userInfoEntityBean.setNick(bean.getNickName());
        return userInfoEntityBean;

    }

    public static List<UserInfoEntityBean> covert(List<UserInfoEntity> beans) {
        if (beans == null) {
            return null;
        }
        Map<Long, UserInfoEntity> userIdEntityMap = beans.stream().collect(Collectors.toMap(UserInfoEntity::getUserId, Function.identity(), (K1, K2) -> K1));
        List<UserInfoEntityBean> list = JSONObject.parseObject(JSON.toJSONString(beans), new TypeReference<List<UserInfoEntityBean>>(){});

        list.stream().forEach(userInfoEntityBean->{
            UserInfoEntity bean = userIdEntityMap.get(userInfoEntityBean.getUserId());
            userInfoEntityBean.setAvatar(bean.getPhoto());
            userInfoEntityBean.setNick(bean.getNickName());
        });
        return list;

    }
}
