package cn.quantgroup.xyqb.service.session;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.AuthBean;
import cn.quantgroup.xyqb.model.LoginProperties;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.session.SessionValue;

import java.util.List;

/**
 * Created by 11 on 2016/12/28.
 */
public interface ISessionService {


    SessionStruct createSessionAndPersist(User user, LoginProperties loginProperties,Integer tenantId);

    void persistSession(String token, SessionValue sessionValue,Integer tenantId);
    void persistSession(String token, SessionValue sessionValue,Long time,Integer tenantId);

    void deleteByUserId(long userId,Integer tenantId);

    void deleteUserCatch(User user,Integer tenantId);

    List<SessionStruct> findByUserId(long userId,Integer tenantId);

    void persistSession(List<SessionStruct> sessionStructList,Integer tenantId);

    /**
     * 删除会话
     */
    void deleteSession(String token,Integer tenantId);

    void persistSessionExchange(String token, SessionValue sessionValue, long expire,Integer tenantId);

    void kdspDeleteSession(Long userId, LoginProperties loginProperties,Integer tenantId);

    /**
     * 更新session
     * 用户信息存在,更新session中的最后访问时间,重新写入缓存.
     * 存在则保存用户session信息,userId为uuid
     *
     * @param user - 登录用户
     * @param loginProperties - 登录参数
     * @param ordinal - 登录方式
     * @return
     */
    AuthBean createSession(User user, LoginProperties loginProperties, int ordinal,Integer tenantId);
}
