package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.tech.db.DSType;
import cn.quantgroup.tech.db.TargetDataSource;
import cn.quantgroup.user.enums.BizType;
import cn.quantgroup.user.enums.IncomeRangeEnum;
import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.aspect.lock.RedisLock;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.controller.internal.user.resp.UserFullResp;
import cn.quantgroup.xyqb.entity.*;
import cn.quantgroup.xyqb.event.PhoneNoUpdateEvent;
import cn.quantgroup.xyqb.exception.DataException;
import cn.quantgroup.xyqb.exception.UserNotExistException;
import cn.quantgroup.xyqb.exception.UserRegisterLoginException;
import cn.quantgroup.xyqb.model.*;
import cn.quantgroup.xyqb.repository.*;
import cn.quantgroup.xyqb.service.register.IUserDeregisterService;
import cn.quantgroup.xyqb.service.register.IUserRegisterService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.user.*;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import cn.quantgroup.xyqb.util.*;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sensorsdata.analytics.javasdk.ISensorsAnalytics;
import com.sensorsdata.analytics.javasdk.bean.EventRecord;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * Created by Miraculous on 15/7/5.
 */
@Service
@Slf4j
public class LoginRecordServiceImpl implements ILoginRecordService, IBaseController {

    @Autowired
    private ILoginRecordRepository loginRecordRepository;

    @Override
    public void saveLoginRecord(Long userId, String name) {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        LoginRecord loginRecord = new LoginRecord();
        loginRecord.setUserId(userId);
        loginRecord.setType(name);
        String qgTenantId = request.getHeader("qg-tenant-id");
        String vccChannel = request.getHeader("vccChannel");
        if (null != qgTenantId && !"".equals(qgTenantId)) {
            loginRecord.setQgTenantId(Long.parseLong(qgTenantId));
        }
        if (null != vccChannel && !"".equals(vccChannel)) {
            loginRecord.setVccChannel(Long.parseLong(vccChannel));
        }
        loginRecord.setUserTerminal(request.getHeader("x-user-terminal"));
        loginRecord.setIp(request.getHeader("x-original-client-ip"));
        loginRecord.setAppName(request.getHeader("appName"));
        loginRecord.setVersion(request.getHeader("version"));
        loginRecord.setUserAgent(request.getHeader("User-Agent"));
        loginRecord.setDeviceId(request.getHeader("scDeviceId"));
        loginRecord.setAppChannel(request.getHeader("appChannel"));
        loginRecordRepository.saveAndFlush(loginRecord);
    }
}
