package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.constant.enums.LoginType;
import cn.quantgroup.xyqb.controller.req.v2.LoginReq;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.exception.BizException;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.exception.SilentBizException;
import cn.quantgroup.xyqb.model.AuthBean;
import cn.quantgroup.xyqb.model.LoginBean;
import cn.quantgroup.xyqb.model.LoginProperties;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.v2.login.BaseLoginParam;
import cn.quantgroup.xyqb.model.v2.login.InterLoginParam;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.user.ILockIpv4Service;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/**
 * 免密登录
 */
@Service
@Slf4j
public class InterLoginStrategy implements LoginStrategy {

    private final ILockIpv4Service lockIpv4Service;

    private final IUserService userService;
    private final IWechatService wechatService;
    private final ISessionService sessionService;

    public InterLoginStrategy(ILockIpv4Service lockIpv4Service, IUserService userService, IWechatService wechatService, ISessionService sessionService) {
        this.lockIpv4Service = lockIpv4Service;
        this.userService = userService;
        this.wechatService = wechatService;
        this.sessionService = sessionService;
    }

    @Override
    public Integer getType() {
        return 9000;
    }

    @Override
    public LoginBean login(BaseLoginParam param) {
        InterLoginParam interLoginParam = (InterLoginParam) param;
        SessionStruct sessionStruct = XyqbSessionContextHolder.getXSession();
        User user = null;

        //1、根据前端的条件，进行查询用户信息
        if (interLoginParam.getUserId() != null) {
            user = userService.findById(interLoginParam.getUserId(), sessionStruct.getTenantId());
        }
        if (StringUtils.isNotEmpty(interLoginParam.getUuid())) {
            user = userService.findByUuidInDb(interLoginParam.getUuid(), sessionStruct.getTenantId());
        }
        if (StringUtils.isNotEmpty(interLoginParam.getPhoneNo())) {
            user = userService.findByPhoneInDb(interLoginParam.getPhoneNo(), sessionStruct.getTenantId());
        }

        if (StringUtils.isNotEmpty(interLoginParam.getAppId()) && StringUtils.isNotEmpty(interLoginParam.getOpenId())) {
            WechatUserInfo wechatUserInfo = wechatService.findWechatUserInfoFromDb(interLoginParam.getOpenId(), interLoginParam.getAppId(), sessionStruct.getTenantId());
            if (wechatUserInfo == null || wechatUserInfo.getUserId() == null) {
                throw new SilentBizException(BizExceptionEnum.UN_EXIT_USER);
            }

            user = userService.findById(wechatUserInfo.getUserId(), sessionStruct.getTenantId());
        }

        if (StringUtils.isNotEmpty(interLoginParam.getAppId()) && StringUtils.isNotEmpty(interLoginParam.getUnionId())) {
            WechatUserInfo wechatUserInfo = wechatService.findByUnionIdAndAppIdAndTenantId(interLoginParam.getUnionId(), interLoginParam.getAppId(), sessionStruct.getTenantId());
            if (wechatUserInfo == null || wechatUserInfo.getUserId() == null) {
                throw new SilentBizException(BizExceptionEnum.UN_EXIT_USER);
            }

            user = userService.findById(wechatUserInfo.getUserId(), sessionStruct.getTenantId());
        }

        if (user == null) {
            throw new SilentBizException(BizExceptionEnum.UN_EXIT_USER);

        }
        // 临时的限制泄露账户的用户不让用户的小程序登陆,在上线微信解绑功能后删除
        if (StringUtils.isNotEmpty(interLoginParam.getAppId()) && StringUtils.isNotEmpty(interLoginParam.getOpenId())){
            if(user.getId().equals(53007786L) || user.getId().equals(9440153L)){
                log.info("用户，限制小程序登陆，userId:{}", user.getId());
                throw new SilentBizException(BizExceptionEnum.ERROR_WECHAT_LOGIN);
            }
        }

        //2、需要判断是否是否启用
        if (!user.getEnable()) {
            log.info("用户不存在，或者已经注销，phoneNo:{}", user.getPhoneNo());
            throw new SilentBizException(BizExceptionEnum.ERROR_OR_ENABLE_ERROR);
        }

        LoginProperties loginProperties = new LoginProperties(1, sessionStruct.getRegisteredFrom(), sessionStruct.getTenantId());
        AuthBean authBean = sessionService.createSession(user, loginProperties, LoginType.SUPERLOGIN.ordinal(), sessionStruct.getTenantId(),false);
        LoginBean loginBean = new LoginBean();
        if (authBean != null) {
            loginBean.setToken(authBean.getToken());
            loginBean.setPhoneNo(authBean.getPhoneNo());
            loginBean.setUuid(authBean.getUuid());
            loginBean.setHasPassword(authBean.isHasPassword());
            loginBean.setUserId(user.getId());
            loginBean.setTenantId(user.getTenantId());
        }
        loginBean.setRegister(false);
        lockIpv4Service.unLockPhone(user.getPhoneNo());

        return loginBean;
    }

    @Override
    public BaseLoginParam checkParam(LoginReq loginReq) {
        InterLoginParam param = loginReq.getData().toJavaObject(InterLoginParam.class);
        if (param.getUserId() == null && StringUtils.isEmpty(param.getUuid())
                && (StringUtils.isEmpty(param.getOpenId()) && StringUtils.isEmpty(param.getAppId())) && (StringUtils.isEmpty(param.getUnionId()) && StringUtils.isEmpty(param.getAppId()))
                && StringUtils.isEmpty(param.getPhoneNo())) {
            throw new BizException(BizExceptionEnum.ERROR_LOGIN_PARAM);
        }
        return param;
    }


}
