package cn.quantgroup.xyqb.controller.middleoffice.wx;

import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 微信
 */
@Slf4j
@RestController
@RequestMapping("/middle_office/wx")
public class WxController {

    @Resource
    private IWechatService wechatService;

    /**
     * http://open.quantgroups.com/project/59/interface/api/693
     * @param userId
     * @return
     */
    @GetMapping("/userId/{userId}")
    public JsonResult openId(@PathVariable Long userId) {
        WechatUserInfo wechatUserInfo = wechatService.queryByUserId(userId);
        if (wechatUserInfo == null) {
            return JsonResult.buildSuccessResult();
        }
        return JsonResult.buildSuccessResultGeneric(wechatUserInfo.getOpenId());
    }

    @GetMapping("/userId/{userId}/{appName}")
    public JsonResult openId(@PathVariable Long userId,@PathVariable String appName) {
        WechatUserInfo wechatUserInfo = wechatService.queryByUserId(userId,appName);
        if (wechatUserInfo == null) {
            return JsonResult.buildSuccessResult();
        }
        return JsonResult.buildSuccessResultGeneric(wechatUserInfo.getOpenId());
    }

    /**
     * http://open.quantgroups.com/project/59/interface/api/693
     * @param phoneNo
     * @return
     */
    @GetMapping("/phoneNo/{phoneNo}")
    public JsonResult openId(@PathVariable String phoneNo) {
        WechatUserInfo wechatUserInfo = wechatService.findWechatUserInfoByPhoneNo(phoneNo);
        if (wechatUserInfo == null) {
            return JsonResult.buildSuccessResult();
        }
        return JsonResult.buildSuccessResultGeneric(wechatUserInfo.getOpenId());
    }

    @RequestMapping("/code/{key}/{extdata}")
    public void receiveCode(@PathVariable String key, @PathVariable String extdata) {
        //todo
    }

    @PatchMapping("/forbidden/{userId}")
    public JsonResult forbidden(@PathVariable Long userId, String reason) {
        int res = wechatService.forbiddenUserWeChat(userId);
        log.info("取消微信关联 userId:{},reason:{},结果:{}", userId, reason, res);
        return JsonResult.buildSuccessResultGeneric(res);
    }
}
