package cn.quantgroup.xyqb.service.auth.impl;

import cn.quantgroup.xyqb.entity.UserAuthorized;
import cn.quantgroup.xyqb.model.AuthPattern;
import cn.quantgroup.xyqb.model.UserAuthorizedParam;
import cn.quantgroup.xyqb.repository.IUserAuthorizedRepository;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.auth.IUserAuthorizedService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.sql.Timestamp;
import java.text.ParseException;

/**
 * @author xufei on 2018/1/5.
 */
@Service
public class UserAuthorizedServiceImpl implements IUserAuthorizedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAuthorizedServiceImpl.class);
    @Resource
    private IIdCardService iIdCardService;

    @Resource
    private IUserAuthorizedRepository userAuthorizedRepository;

    @Override
    public Boolean hasUserAuthorized(String idNo) {
        try {
            if (StringUtils.isBlank(idNo) || !iIdCardService.isIdCardValid(idNo)) {
                return Boolean.FALSE;
            }
        } catch (ParseException e) {
            LOGGER.error("[hasUserAuthorized]参数异常e:{}", e);
        }

        UserAuthorized userAuthorized = userAuthorizedRepository.findByIdNo(idNo);
        LOGGER.info("[hasUserAuthorized]查询实名账户userAuthorized:{}", userAuthorized);
        return null != userAuthorized;
    }

    @Override
    public Boolean checkUserAuthorizedParam(UserAuthorizedParam userAuthorizedParam) throws Exception {
        if (null == userAuthorizedParam) {
            return Boolean.TRUE;
        }
        Long userId = userAuthorizedParam.getUserId();
        String userUuid = userAuthorizedParam.getUserUuid();
        if (userId == null || userId == 0L) {
            if (StringUtils.isBlank(userUuid)) {
                return Boolean.TRUE;
            }
        }
        String name = userAuthorizedParam.getName();
        String authPattern = userAuthorizedParam.getAuthPattern();
        String idNo = userAuthorizedParam.getIdNo();
        return (StringUtils.isBlank(name) || StringUtils.isBlank(authPattern) || !iIdCardService.isIdCardValid(idNo));
    }

    @Override
    public UserAuthorized createUserAuthorized(UserAuthorizedParam userAuthorizedParam) {
        AuthPattern authPatternEnum = AuthPattern.valueOf(userAuthorizedParam.getAuthPattern());

        UserAuthorized userAuthorized = new UserAuthorized();
        userAuthorized.setAuthPattern(authPatternEnum);
        userAuthorized.setAvailable(Boolean.TRUE);
        userAuthorized.setName(userAuthorizedParam.getName());
        userAuthorized.setIdNo(userAuthorizedParam.getIdNo());
        userAuthorized.setUserUuid(userAuthorizedParam.getUserUuid());
        Timestamp now = new Timestamp(System.currentTimeMillis());
        userAuthorized.setCreatedAt(now);
        userAuthorized.setUpdatedAt(now);

        try {
            userAuthorized = userAuthorizedRepository.save(userAuthorized);
            LOGGER.info("[createUserAuthorized]创建实名账户成功,userAuthorized:{}", userAuthorized);
            return userAuthorized;
        } catch (Exception e) {
            LOGGER.error("[createUserAuthorized]创建实名账户异常e:{}", e);
            return null;
        }
    }

    @Override
    public String getUserAuthorizedId(String userUuid) {
        if (StringUtils.isBlank(userUuid)) {
            return null;
        }

        UserAuthorized userAuthorized = userAuthorizedRepository.findByUserUuid(userUuid);
        LOGGER.info("[getUserAuthorizedId]获取实名账户的id,userUuid:{},userAuthorized:{}", userUuid,userAuthorized);
        if (null == userAuthorized) {
            return null;
        }
        return userAuthorized.getId();
    }
}
