package cn.quantgroup.xyqb.config.data;


import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import java.util.Properties;

/**
 * 登录风控拦截数据库
 */
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = {"cn.quantgroup.xyqb.risk.repository"},
        entityManagerFactoryRef = "riskEntityManager",
        transactionManagerRef = "riskTransactionManager")
public class LoginRiskJpaConfig {

    @Value("${login.risk.datasource.url}")
    private String dataSourceUrl;

    @Value("${login.risk.datasource.password}")
    private String password;

    @Value("${login.risk.datasource.username}")
    private String username;

    @Value("${xyqb.data.mysql.max-pool-size}")
    private Integer maxPoolSize;

    private static final String DATABASE_TYPE_DEFAULT = "com.mysql.jdbc.Driver";

    @Bean(name = "riskEntityManager")
    @DependsOn("riskDataSource")
    public EntityManagerFactory entityManagerFactory(
            @Qualifier("riskDataSource") DataSource dataSource
    ) {
        LocalContainerEntityManagerFactoryBean entityManager = new LocalContainerEntityManagerFactoryBean();
        entityManager.setDataSource(dataSource);
        entityManager.setPackagesToScan("cn.quantgroup.xyqb.risk");
        entityManager.setPersistenceUnitName("riskDataSource");
        Properties properties = new Properties();
        properties.put("hibernate.jdbc.batch_size", 30);
        properties.put("hibernate.order_inserts", true);
        properties.put("hibernate.order_updates", true);

        entityManager.setJpaProperties(properties);
        entityManager.setJpaVendorAdapter(jpaVendorAdapter());
        entityManager.afterPropertiesSet();
        return entityManager.getObject();
    }

    private JpaVendorAdapter jpaVendorAdapter() {
        HibernateJpaVendorAdapter hibernateJpaVendorAdapter = new HibernateJpaVendorAdapter();
        hibernateJpaVendorAdapter.setShowSql(false);
        hibernateJpaVendorAdapter.setGenerateDdl(false);
        hibernateJpaVendorAdapter.setDatabase(Database.MYSQL);
        return hibernateJpaVendorAdapter;
    }


    @Bean(name = "riskTransactionManager")
    @DependsOn("riskEntityManager")
    public PlatformTransactionManager transactionManager(
            @Qualifier("riskEntityManager") EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManagerFactory);
        return transactionManager;
    }

    @Bean(name = "riskJdbcTemplate")
    @DependsOn("riskDataSource")
    public JdbcTemplate jdbcTemplate(@Qualifier("riskDataSource") DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource(dataSource);
        return jdbcTemplate;
    }


    /**
     * private static final String DATASOURCE_TYPE_DEFAULT =
     * "com.zaxxer.hikari.HikariDataSource";
     * private static final String DATABASE_TYPE_DEFAULT =
     * "com.mysql.jdbc.Driver";
     * private static final String MASTER_PREFIX =
     * "spring.datasource.";
     * private static final String SLAVE_PREFIX =
     * "slave.datasource.";
     *
     * @return
     */
    @Bean(name = "riskDataSource")
    public DataSource riskDataSource() {
        DataSourceBuilder factory = DataSourceBuilder
                .create()
                .driverClassName(DATABASE_TYPE_DEFAULT)
                .url(dataSourceUrl)
                .username(username)
                .password(password)
                .type(HikariDataSource.class);
        return factory.build();
    }

}
