package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.User;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.Collection;
import java.util.LinkedList;

/**
 * Created by Miraculous on 15/7/5.
 */
public class AuthenticationUserDetail extends User implements UserDetails {

    private static final long serialVersionUID = -1L;

    public AuthenticationUserDetail(User user) {
        this.setPhoneNo(user.getPhoneNo());
        this.setId(user.getId());
        this.setRegisteredFrom(user.getRegisteredFrom());
        this.setPassword(user.getPassword());
        this.setUuid(user.getUuid());
        this.setEnable(user.getEnable());
    }

    @Override
    public Collection<? extends GrantedAuthority> getAuthorities() {
        Collection<GrantedAuthority> authorities = new LinkedList<>();
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        return authorities;
    }

    @Override
    public String getPassword() {
        return super.getPassword();
    }

    @Override
    public String getUsername() {
        return super.getPhoneNo();
    }

    @Override
    public boolean isAccountNonExpired() {
        return true;
    }

    @Override
    public boolean isAccountNonLocked() {
        return true;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return super.getEnable();
    }
}
