package cn.quantgroup.xyqb.model;

import cn.quantgroup.user.enums.Relation;
import cn.quantgroup.xyqb.entity.Contact;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * Created by Miraculous on 2017/2/14.
 */
@Data
public class ContactRet implements Serializable {

    private static final long serialVersionUID = -1L;
    private Long id;
    private Long userId;
    private String name;
    private String phoneNo;
    private Relation relation;
    private Long createdAt;
    private Long updateAt;


    private static ContactRet contact2ContactRet(Contact c) {
        if (c == null) {
            return null;
        }
        ContactRet ret = new ContactRet();
        ret.setId(c.getId());
        ret.setUserId(c.getUserId());
        ret.setName(c.getName());
        ret.setPhoneNo(c.getPhoneNo());
        ret.setRelation(c.getRelation());
        if(Objects.nonNull(c.getCreatedAt())){
            ret.setCreatedAt(c.getCreatedAt().getTime());
        }
        if(Objects.nonNull(c.getUpdateAt())) {
            ret.setUpdateAt(c.getUpdateAt().getTime());
        }
        return ret;
    }

    public static List<ContactRet> contacts2ContactRets(List<Contact> cs) {
        if (CollectionUtils.isEmpty(cs)) {
            return Collections.emptyList();
        }
        List<ContactRet> contactRets = new ArrayList<>();
        for (Contact c : cs) {
            contactRets.add(contact2ContactRet(c));
        }
        return contactRets;
    }
}
