package cn.quantgroup.xyqb.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;

/**
 * Created by liqing on 2017/12/4 0004.
 */
@Slf4j
public class JsonUtil {

    /**
     * 转换json为对象
     *
     * @param jsonStr
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> Optional<T> fromJson(String jsonStr, Class<T> clazz) {
        try {
            return Optional.ofNullable(JSONObject.parseObject(jsonStr, clazz));
        } catch (Exception e) {
            log.error("[exception][fromJson_exception]error={}", e);
        }
        return Optional.empty();
    }

    /**
     * 将对象转成json字符串
     *
     * @param object
     * @return
     */
    public static String toJson(Object object) {
        return JSONObject.toJSONString(object);
    }
}
