package cn.quantgroup.xyqb.service.jr58.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.entity.UserJr58;
import cn.quantgroup.xyqb.model.IdCardInfo;
import cn.quantgroup.xyqb.model.IdType;
import cn.quantgroup.xyqb.model.jr58.Jr58Authorization;
import cn.quantgroup.xyqb.model.jr58.Jr58RegisterParam;
import cn.quantgroup.xyqb.model.jr58.Jr58RegisterResult;
import cn.quantgroup.xyqb.repository.IUserDetailRepository;
import cn.quantgroup.xyqb.repository.IUserJr58Repository;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.jr58.Jr58Service;
import cn.quantgroup.xyqb.service.user.ILkbUserService;
import cn.quantgroup.xyqb.util.GZipUtil;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.transaction.Transactional;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Base64;
import java.util.Map;

/**
 * @author mengfan.feng
 * @time 2015-09-09 16:46
 */
@Service
public class Jr58ServiceImpl implements Jr58Service {

  private static final Logger LOGGER = LoggerFactory.getLogger(Jr58ServiceImpl.class);

  @Autowired
  private ILkbUserService lkbUserService;

  @Autowired
  private IUserJr58Repository userJr58Repository;

  @Autowired
  private IHttpService httpService;

  @Value("${xyqb.api.url}")
  private String apiUrl;

  @Value("${lkb.import.url}")
  private String pushImportForJr58Url;

  @Autowired
  private IUserRepository userRepository;

  @Autowired
  private IUserDetailRepository userDetailRepository;

  @Autowired
  private IIdCardService idCardService;


  @Override
  @Transactional(value = Transactional.TxType.REQUIRED)
  public String register(Jr58RegisterParam param) {
    String uuid;
    User user = userRepository.findByPhoneNo(param.getPhone());

    /***************** 用户是否在新系统存在 ********************/
    if (user != null) {
      uuid = user.getUuid();
      return uuid;
    }

    /***************** 向老系统注册用户 ********************/
    Jr58RegisterResult result = lkbUserService.registerJr58(param);
    if (result == null || !"0".equals(result.getErrorcode())) {
      LOGGER.warn("向LKB注册58金融用户失败, param:{}", param);
      return "";
    }

    /***************** 用户已经在老系统存在 ********************/
    uuid = result.getCustomerid();
        /*if (result.getHasUser()) {
            LOGGER.info("该用户已经在LKB系统中存在, uuid:{}", uuid);
            return uuid;
        }*/


    /***************** 新用户 ********************/
    LOGGER.info("Save User:{}", uuid);
    user = this.saveUser(param, uuid);
    if (user == null) {
      throw new RuntimeException("保存用户信息出错");
    }
    LOGGER.info("Save UserDetail:{}", user.getId());
    this.saveUserDetail(param, user.getId());

    LOGGER.info("Save UserJr58:{}", user.getId());
    this.saveUserJr58(param, user.getId());

    LOGGER.info("用户注册成功, registerFrom:{}, phoneNo:{}", Constants.Channel.JR58, param.getPhone());
    return uuid;
  }

  @Override
  public void getRidOfFillingProfile(User user, String phoneNo) throws UnsupportedEncodingException {
    if (user == null) {
      LOGGER.info("58用户不存在");
      return;
    }
    Map<String, String> parameters = ImmutableMap.<String, String>builder()
        .put("userId", user.getId().toString())
        .put("key", "abc1234")
        .put("phoneNo", phoneNo)
        .build();
    LOGGER.info("调用58保存用户贷款信息接口开始");
    httpService.get(apiUrl + "/ex/auth-58/info", parameters);
    LOGGER.info("调用58保存用户贷款信息接口结束");
  }

  /**
   * Save UserJr58
   *
   * @param param
   * @param userId
   */
  private void saveUserJr58(Jr58RegisterParam param, Long userId) {
    Timestamp currentTime = new Timestamp(System.currentTimeMillis());

    UserJr58 userJr58 = new UserJr58();
    userJr58.setUserId(userId);
    userJr58.setWbId(param.getWbId());
    userJr58.setWbUserName(param.getWbUserName());
    userJr58.setCustomerId(param.getCustomerId());
    userJr58.setName(param.getName());
    userJr58.setIdcard(param.getIdcard());
    userJr58.setEmail(StringUtils.substring(param.getEmail(), 0, 50));
    userJr58.setPhone(param.getPhone());
    userJr58.setInfo(param.getInfo());
    userJr58.setRoleId(param.getRoleId());
    userJr58.setFlag(param.getFlag());
    userJr58.setCity(param.getCity());
    userJr58.setAccessMode(param.getAccessMode());
    userJr58.setAppId(param.getAppId());
    userJr58.setCreatedAt(currentTime);
    userJr58.setUpdatedAt(currentTime);
    userJr58.setEdu(param.getEdu());
    userJr58.setIncome(param.getIncome());
    userJr58.setMarry(param.getMarry());
    userJr58Repository.saveAndFlush(userJr58);
  }

  /**
   * Save UserDetail
   *
   * @param param
   * @param userId
   */
  private void saveUserDetail(Jr58RegisterParam param, Long userId) {
    Timestamp currentTime = new Timestamp(System.currentTimeMillis());
    IdCardInfo idCardInfo = param.getIdCardInfo();
    UserDetail userDetail = new UserDetail();
    userDetail.setUserId(userId);
    userDetail.setName(param.getName());
    userDetail.setPhoneNo(param.getPhone());
    userDetail.setIdNo(param.getIdcard());
    Timestamp time = new Timestamp(System.currentTimeMillis());
    userDetail.setCreatedAt(time);
    userDetail.setUpdatedAt(time);
    userDetail.setIdType(IdType.ID_CARD);
    try {
      userDetail.setGender(idCardService.getIdCardInfo(param.getIdcard()).getGender());
    } catch (ParseException e) {
      LOGGER.error("根据身份证获取性别出错,错误信息:" + e);
    }
    userDetail.setEmail(StringUtils.substring(param.getEmail(), 0, 30));
    userDetailRepository.saveAndFlush(userDetail);
  }

  /**
   * Save User
   *
   * @param param
   * @param uuid
   */
  private User saveUser(Jr58RegisterParam param, String uuid) {
    Timestamp currentTime = new Timestamp(System.currentTimeMillis());
    User user = new User();
    user.setPhoneNo(param.getPhone());
    user.setCreatedAt(currentTime);
    user.setUpdatedAt(currentTime);
    user.setEnable(true);
    user.setRegisteredFrom(Constants.Channel.JR58);
    user.setUuid(uuid);
    user.setPassword("");
    user = userRepository.save(user);
    return userRepository.saveAndFlush(user);
  }


  /**
   * 推送授权数据
   */
  @Async
  public void pushAuthorizationData(Jr58Authorization authorizationData) {
    LOGGER.info("运营商授权数据推送到lkb开始");
    Map<String, String> parameters = null;
    String url = "";
    //量化派数据
    if ("0".equals(authorizationData.getSourceFrom())) {
      parameters = ImmutableMap.<String, String>builder()
          .put("Content-Type", "application/x-www-form-urlencoded;charset=utf-8")
          .put("loginName", authorizationData.getOperator_data().getOriginalData().getPhone())
          .put("currentUser", authorizationData.getUserId())
          .put("userSource", "YUNYINGSHANG")
          .build();
      url = pushImportForJr58Url + "/SpiderServer/api/dataTransfer/saveUserAuthInfo.json";
    } else if ("1".equals(authorizationData.getSourceFrom())) {
      //读秒数据
      //String graspingJson = Constants.GSON.toJson(authorizationData.getOperator_data());
      String graspingJson = JSONObject.toJSONString(authorizationData.getOperator_data());
      byte[] graspingJsonBytes = GZipUtil.compressToByte(graspingJson);
      String authorizationDataStr = Base64.getEncoder().encodeToString(graspingJsonBytes);
      parameters = ImmutableMap.<String, String>builder()
          .put("Content-Type", "application/x-www-form-urlencoded;charset=utf-8")
          .put("data", authorizationDataStr)
          .put("currentUser", authorizationData.getUserId())
          .put("source", "58")
          .build();
      url = pushImportForJr58Url + "/SpiderServer/api/dataTransfer/receive.json";
    }
    for (int i = 0; i < 4; i++) {
      try {
        String response = httpService.post(url, parameters);
        if (response.contains(",\"status\":1,")) {
          LOGGER.info("运营商授权数据推送到lkb成功");
          break;
        } else {
          Thread.sleep(2000);
          LOGGER.error("运营商授权数据推送到lkb中失败 - {}  ,userId ={}, response = {} url ={}", i + 1, authorizationData.getUserId(), response, url);
        }
      } catch (InterruptedException e) {
        LOGGER.error("运营商授权数据推送到失败  url ={}", url);
      }
    }

    LOGGER.info("运营商授权数据推送到lkb结束");

  }

  @Async
  @Override
  public void pushAuthorizationStatus(String userId, String account, String authorizationType) {
    LOGGER.info("通知lkb授权成功- 开始");
    Map<String, String> parameters = ImmutableMap.<String, String>builder()
        .put("Content-Type", "application/x-www-form-urlencoded;charset=utf-8")
        .put("loginName", account)
        .put("currentUser", userId)
        .put("userSource", "YUNYINGSHANG")
        .build();
    String url = pushImportForJr58Url + "/SpiderServer/api/dataTransfer/saveUserAuthInfo.json";
    for (int i = 0; i < 4; i++) {
      try {
        String response = httpService.post(url, parameters);
        if (response.contains(",\"status\":1,")) {
          LOGGER.info("通知lkb授权成功");
          break;
        } else {
          Thread.sleep(2000);
          LOGGER.error("通知lkb授权失败 - {}  ,userId ={}, response = {} url ={}", i + 1, userId, response, url);
        }
      } catch (InterruptedException e) {
        LOGGER.error("通知lkb授权失败  url ={}", url);
      }
    }
    LOGGER.info("通知lkb授权- 结束");
  }
}
