package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.xyqb.aspect.accessable.IpValidator;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.entity.Merchant;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.*;
import cn.quantgroup.xyqb.model.session.LoginInfo;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.merchant.IMerchantService;
import cn.quantgroup.xyqb.service.register.IUserRegisterService;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.service.user.ILkbUserService;
import cn.quantgroup.xyqb.service.user.IUserBtRegisterService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.IPUtil;
import cn.quantgroup.xyqb.util.MqUtils;
import cn.quantgroup.xyqb.util.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;

import static cn.quantgroup.xyqb.constant.UserConstant.USER_ERROR_OR_PASSWORD_ERROR;

/**
 * @author mengfan.feng
 * @time 2015-10-27 11:41
 */
@RestController
@RequestMapping("/app")
public class AppController implements IBaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(AppController.class);
  private final static Random random = new Random();
  @Autowired
  private ISessionService sessionService;
  @Autowired
  private IUserService userService;
  @Autowired
  private ILkbUserService lkbUserService;
  @Autowired
  private IUserRepository userRepository;
  @Autowired
  private IUserDetailService userDetailService;
  @Autowired
  private IIdCardService idCardService;
  @Autowired
  private IMerchantService merchantService;
  @Autowired
  private IUserBtRegisterService userBtRegisterService;
  @Autowired
  private IUserRegisterService userRegisterService;
  /**
   * 第三方用户登录
   */
  @IpValidator
  @RequestMapping("/login")
  public JsonResult login(
      String phoneNo,
      @RequestParam(required = false, defaultValue = "1") Long registerFrom,
      @RequestParam(required = false, defaultValue = "1") Long channelId,
      String idNo, String name, String key, @RequestParam(required = false, defaultValue = "") String appChannel,@RequestParam(required = false)Long btRegisterChannelId,HttpServletRequest request
  ) {
    if (!ValidationUtil.validatePhoneNo(phoneNo)) {
      return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
    }
    // Todo -- 截止2017-12-08 13:44:00只有52次调用记录，来自222（白条），最近一次：2017-11-11 12:15:53
    LOGGER.info("第三方用户登录 login --> loginFrom:{},channelId：{},btRegisterChannelId:{} requestIp:{},idNo:{},name:{}", registerFrom,channelId,btRegisterChannelId, IPUtil.getRemoteIP(request),idNo,name);
    User user = userService.findByPhoneInDb(phoneNo);
    if (user == null) {
      user = userRegisterService.register(registerFrom, phoneNo, idNo, name, channelId,btRegisterChannelId);
    }
    if (user == null) {
      return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
    }
    if (!user.getEnable()) {
      return JsonResult.buildErrorStateResult("登录失败", null);
    }
    Merchant merchant = merchantService.findMerchantByName(key);
    if (merchant == null) {
      return JsonResult.buildErrorStateResult("无效的商户", null);
    }
    LoginProperties loginProperties = new LoginProperties();
    loginProperties.setChannelId(channelId);
    loginProperties.setMerchantName(merchant.getName());
    loginProperties.setCreatedFrom(registerFrom);
    loginProperties.setAppChannel(appChannel);
    SessionStruct sessionStruct = sessionService.createSessionAndPersist(user, loginProperties);
    AuthBean bean = new AuthBean();
    bean.setToken(sessionStruct.getSid());
    bean.setPhoneNo(phoneNo);
    LOGGER.info("第三方用户登录成功 login --> loginFrom:{}, phoneNo:{},appChannel:{}", registerFrom, phoneNo, appChannel);

    return new JsonResult(bean);
  }

  /**
   * 给app用
   */
  @IpValidator
  @RequestMapping("/login2")
  public JsonResult login2(
      String phoneNo,
      @RequestParam(required = false, defaultValue = "1") Long registerFrom,
      @RequestParam(required = false, defaultValue = "1") Long channelId, @RequestParam(required = false, defaultValue = "") String appChannel, HttpServletRequest request
  ) {
    AuthBean bean = new AuthBean();

    if (!ValidationUtil.validatePhoneNo(phoneNo)) {
      return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
    }

    LOGGER.info("第三方用户登录 login2 --> loginFrom:{},channelId:{}, requestIp:{}", registerFrom,channelId, IPUtil.getRemoteIP(request));
    User user = userService.findByPhoneInDb(phoneNo);

    if (user == null) {
      return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
    }
    if (!user.getEnable()) {
      return JsonResult.buildErrorStateResult("登录失败", null);
    }

    LoginProperties loginProperties = new LoginProperties();
    loginProperties.setChannelId(channelId);
    loginProperties.setCreatedFrom(registerFrom);
    loginProperties.setAppChannel(appChannel);
    SessionStruct sessionStruct = sessionService.createSessionAndPersist(user, loginProperties);

    bean.setToken(sessionStruct.getSid());
    bean.setPhoneNo(phoneNo);

    LOGGER.info("第三方用户登录成功 login2 --> loginFrom:{}, phoneNo:{},appChannel:{}", registerFrom, phoneNo, appChannel);
    return new JsonResult(bean);
  }


  /**
   * 第三方用户登录并返回用户信息
   */
  @IpValidator
  @RequestMapping("/login_super")
  public JsonResult loginSuper(
      String phoneNo,
      @RequestParam(required = false, defaultValue = "1") Long registerFrom,
      @RequestParam(required = false, defaultValue = "1") Long channelId,
      String idNo, String name, String key, @RequestParam(required = false, defaultValue = "") String appChannel, @RequestParam(required = false) Long btRegisterChannelId,HttpServletRequest request
  ) {
    if (!ValidationUtil.validatePhoneNo(phoneNo)) {
      return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
    }

    LOGGER.info("第三方用户登录 loginSuper --> loginFrom:{},phoneNo:{},appChannel:{},channelId：{},btRegisterChannelId:{} requestIp:{},idNo:{},name:{}", registerFrom,phoneNo, appChannel,channelId,btRegisterChannelId, IPUtil.getRemoteIP(request),idNo,name);
    User user = userService.findByPhoneInDb(phoneNo);
    if (user == null) {
      user = userRegisterService.register(registerFrom, phoneNo, idNo, name, channelId,btRegisterChannelId);
    }
    if (user == null) {
      return JsonResult.buildErrorStateResult(USER_ERROR_OR_PASSWORD_ERROR, null);
    }
    if (!user.getEnable()) {
      return JsonResult.buildErrorStateResult("登录失败", null);
    }
    Merchant merchant = merchantService.findMerchantByName(key);
    if (merchant == null) {
      return JsonResult.buildErrorStateResult("无效的商户", null);
    }
    LoginProperties loginProperties = new LoginProperties();
    loginProperties.setChannelId(channelId);
    loginProperties.setMerchantName(merchant.getName());
    loginProperties.setCreatedFrom(registerFrom);
    loginProperties.setAppChannel(appChannel);
    SessionStruct sessionStruct = sessionService.createSessionAndPersist(user, loginProperties);

    LoginInfo loginInfo = new LoginInfo();
    loginInfo.setUser(new UserRet(user));
    loginInfo.setToken(sessionStruct.getSid());
    LoginInfo.LoginContext context = new LoginInfo.LoginContext();
    context.setChannelId(sessionStruct.getValues().getLoginProperties().getChannelId());
    context.setCreatedFrom(sessionStruct.getValues().getLoginProperties().getCreatedFrom());
    context.setAppChannel(appChannel);
    loginInfo.setLoginContext(context);
    LOGGER.info("第三方用户获取信息登录成功 loginSuper --> loginFrom:{}, phoneNo:{},appChannel:{},channelId:{}", registerFrom, phoneNo, appChannel,channelId);
    /*
     * 部分免密渠道登录统计
     * 贷款导航(84660)；壹账通H5(159384)
     */
    Long _registerFrom = Optional.ofNullable(user.getRegisteredFrom()).orElse(registerFrom);
    if(Objects.equals(_registerFrom, 84660L) || Objects.equals(_registerFrom, 159384L)){
      UserStatistics statistics = new UserStatistics(user, null,4, channelId);
      //增加登陆统计发送
      MqUtils.sendLoanVest(statistics);
    }
    return JsonResult.buildSuccessResult("", loginInfo);

  }

}
