package cn.quantgroup.xyqb.event;

import cn.quantgroup.xyqb.entity.User;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

/**
 * 记录手机号变更情况
 *
 * @author 徐小光
 */
@Slf4j
@Component
public class RecordPhoneNoUpdateEventListener implements ApplicationListener<PhoneNoUpdateEvent> {

    @Override
    public void onApplicationEvent(PhoneNoUpdateEvent event) {
        String oldPhoneNo = event.getOldPhoneNo();
        User user = event.getUser();
        //todo 表纪录
        log.info("userId:{},旧手机号:{},新手机号:{}", user.getId(), oldPhoneNo, user.getPhoneNo());
    }
}
