package cn.quantgroup.xyqb.service.auth.impl;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.UserAuthorized;
import cn.quantgroup.xyqb.model.AuthPattern;
import cn.quantgroup.xyqb.model.UserAuthorizedParam;
import cn.quantgroup.xyqb.repository.IUserAuthorizedRepository;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.auth.IUserAuthorizedService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.naming.Name;
import java.sql.Timestamp;
import java.text.ParseException;

/**
 * @author xufei on 2018/1/5.
 */
@Service
public class UserAuthorizedServiceImpl implements IUserAuthorizedService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAuthorizedServiceImpl.class);
    @Resource
    private IIdCardService iIdCardService;

    @Resource
    private IUserAuthorizedRepository userAuthorizedRepository;

    @Override
    public Boolean hasUserAuthorized(String idNo) {
        try {
            if (StringUtils.isBlank(idNo) || !iIdCardService.isIdCardValid(idNo)) {
                return Boolean.FALSE;
            }
        } catch (ParseException e) {
            LOGGER.error("[hasUserAuthorized]参数异常e:{}", e);
        }

        UserAuthorized userAuthorized = userAuthorizedRepository.findByIdNo(idNo);
        LOGGER.info("[hasUserAuthorized]查询实名账户userAuthorized:{}", userAuthorized);
        return null != userAuthorized;
    }

    @Override
    public String createUserAuthorized(UserAuthorizedParam userAuthorizedParam) {
        try {
            if (checkUserAuthorizedParam(userAuthorizedParam)) {
                return Constants.CREATE_USER_AUTHORIZED_FAIL;
            }
        } catch (Exception e) {
            LOGGER.error("[createUserAuthorized]参数有误:{}", e);
            return Constants.CREATE_USER_AUTHORIZED_FAIL;
        }
        return saveUserAuthorized(userAuthorizedParam);
    }

    private Boolean checkUserAuthorizedParam(UserAuthorizedParam userAuthorizedParam) throws Exception {
        if (null == userAuthorizedParam) {
            return Boolean.TRUE;
        }
        String name = userAuthorizedParam.getName();
        Long userId = userAuthorizedParam.getUserId();
        String authPattern = userAuthorizedParam.getAuthPattern();
        String idNo = userAuthorizedParam.getIdNo();
        return (StringUtils.isBlank(name) || userId == null || userId == 0L
                || StringUtils.isBlank(authPattern) || !iIdCardService.isIdCardValid(idNo));
    }

    private String saveUserAuthorized(UserAuthorizedParam userAuthorizedParam) {
        AuthPattern authPatternEnum = AuthPattern.valueOf(userAuthorizedParam.getAuthPattern());

        UserAuthorized userAuthorized = new UserAuthorized();
        userAuthorized.setAuthPattern(authPatternEnum);
        userAuthorized.setAvailable(Boolean.TRUE);
        userAuthorized.setName(userAuthorizedParam.getName());
        userAuthorized.setIdNo(userAuthorizedParam.getIdNo());
        userAuthorized.setUserId(userAuthorizedParam.getUserId());
        Timestamp now = new Timestamp(System.currentTimeMillis());
        userAuthorized.setCreatedAt(now);
        userAuthorized.setUpdatedAt(now);

        try {
            userAuthorized = userAuthorizedRepository.save(userAuthorized);
            LOGGER.info("[createUserAuthorized]创建实名账户成功,userAuthorized:{}", userAuthorized);
            return Constants.CREATE_USER_AUTHORIZED_SUCCESS;
        } catch (Exception e) {
            LOGGER.error("[createUserAuthorized]创建实名账户异常e:{}", e);
            return Constants.CREATE_USER_AUTHORIZED_FAIL;
        }
    }

    @Override
    public Long getUserAuthorizedId(Long userId) {
        if (null == userId || userId == 0) {
            return null;
        }

        UserAuthorized userAuthorized = userAuthorizedRepository.findByUserId(userId);
        if (null == userAuthorized) {
            LOGGER.info("[getUserAuthorizedId]该实名账户不存在userId:{}", userId);
            return null;
        }
        LOGGER.info("[getUserAuthorizedId]获取实名账户的id,userAuthorized:{}", userAuthorized);
        return userAuthorized.getId();
    }
}
