package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.CountDevice;
import cn.quantgroup.xyqb.entity.LoginInfo;
import cn.quantgroup.xyqb.entity.enums.Device;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.scheduling.annotation.Async;

import java.util.List;

public interface LoginInfoRepository extends JpaRepository<LoginInfo, Long> {
    /**
     * 根据设备ID看有多少手机号
     *
     * @param deviceId 设备维度策略
     * @return
     */
    @Query(value = "select count(distinct device_id) from  login_info where device_id=?1 and  created_at> DATE_ADD(CURRENT_TIMESTAMP(),INTERVAL -90 DAY)", nativeQuery = true)
    Long countByDeviceId(String deviceId);


    /**
     * 账号维度策略
     *
     * @param phone
     * @return
     */
//    @Query(value = "select count(1) ,device from  login_info where phone_no=?1 and  last_login_at> DATE_ADD(CURRENT_TIMESTAMP(),INTERVAL -90 DAY  group by device", nativeQuery = true)
    List<CountDevice> countByPhoneAndDevice(String phone);

    /**
     * 查询有没有(手机+设备唯一)
     * @param phone
     * @param device
     * @return
     */
    LoginInfo getFirstByPhoneNoAndDevice(String phone, Device device);

    @Async
    @Override
    <S extends LoginInfo> S save(S s);


}
