package cn.quantgroup.xyqb.validator;

import cn.quantgroup.xyqb.util.IdcardValidator;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;

/**
 * 身份证验证器, <IdCard,String> String 对应的是可以对哪些类型校验
 *
 * @author 徐小光
 */
public class IdCardValidator implements ConstraintValidator<IdCard, String> {
    /**
     * 这个方法在初始化的时候调用. 如果配置错了, 你可以抛一个异常. 启动就报错了
     *
     * @param constraint
     */
    @Override
    public void initialize(IdCard constraint) {
    }

    /**
     * 这....true = 校验通过. false = 校验失败
     *
     * @param idCard  就是那个String
     * @param context
     * @return
     */
    @Override
    public boolean isValid(String idCard, ConstraintValidatorContext context) {
        if (StringUtils.isNotBlank(idCard)) {
            return IdcardValidator.isValidate18Idcard(idCard);
        }
        return true;
    }
}
