package cn.quantgroup.xyqb.controller.middleoffice.wx;

import cn.quantgroup.xyqb.entity.CustomerInfoEntity;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.ITenantService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.service.wechat.IWechatService;
import cn.quantgroup.xyqb.util.TenantUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 微信
 */
@Slf4j
@RestController
@RequestMapping("/middle_office/wx")
public class WxController {

    @Resource
    private IWechatService wechatService;

    @Autowired
    private ITenantService tenantService;

    @Autowired
    private IUserService userService;

    /**
     * @ yapi http://open.quantgroups.com/project/59/interface/api/693
     * @ yapi http://yapi.quantgroups.com/project/17/interface/api/30122
     * @param userId
     * @return
     */
    @GetMapping("/userId/{userId}")
    public JsonResult openId(@PathVariable Long userId, @RequestParam(required = false) Integer tenantId) {
        //默认羊小咩租户
        if (TenantUtil.validationTenantIdIsNullOrZero(tenantId)) {
            tenantId = TenantUtil.TENANT_DEFAULT;
        }
        if (tenantId.equals(TenantUtil.TENANT_DEFAULT)) {
            WechatUserInfo wechatUserInfo = wechatService.queryByUserId(userId);
            if (wechatUserInfo == null) {
                return JsonResult.buildSuccessResult();
            }
            return JsonResult.buildSuccessResultGeneric(wechatUserInfo.getOpenId());
        }else {
            User user = userService.findById(userId);
            if (user == null) {
                return JsonResult.buildSuccessResult();
            }
            CustomerInfoEntity tenantCustomerInfo = tenantService.getTenantCustomerInfo(user, tenantId);
            if (tenantCustomerInfo == null) {
                return JsonResult.buildSuccessResult();
            }
            return JsonResult.buildSuccessResultGeneric(tenantCustomerInfo.getSourceOpenId());
        }
    }

    /**
     * @ yapi http://yapi.quantgroups.com/project/17/interface/api/30122
     * @param userId
     * @param appName
     * @param tenantId
     * @return
     */
    @GetMapping("/userId/{userId}/{appName}")
    public JsonResult openId(@PathVariable Long userId,@PathVariable String appName, @RequestParam(required = false) Integer tenantId) {
        //默认羊小咩租户
        if (TenantUtil.validationTenantIdIsNullOrZero(tenantId)) {
            tenantId = TenantUtil.TENANT_DEFAULT;
        }
        if (tenantId.equals(TenantUtil.TENANT_DEFAULT)) {
            WechatUserInfo wechatUserInfo = wechatService.queryByUserId(userId,appName);
            if (wechatUserInfo == null) {
                return JsonResult.buildSuccessResult();
            }
            return JsonResult.buildSuccessResultGeneric(wechatUserInfo.getOpenId());
        }else {
            User user = userService.findById(userId);
            if (user == null) {
                return JsonResult.buildSuccessResult();
            }
            CustomerInfoEntity tenantCustomerInfo = tenantService.getTenantCustomerInfo(user, tenantId);
            if (tenantCustomerInfo == null) {
                return JsonResult.buildSuccessResult();
            }
            return JsonResult.buildSuccessResultGeneric(tenantCustomerInfo.getSourceOpenId());
        }

    }

    /**
     * @yapi http://open.quantgroups.com/project/59/interface/api/693
     * @yapi http://yapi.quantgroups.com/project/17/interface/api/30122
     * @param phoneNo
     * @return
     */
    @GetMapping("/phoneNo/{phoneNo}")
    public JsonResult openId(@PathVariable String phoneNo, @RequestParam(required = false) Integer tenantId) {
        if (TenantUtil.validationTenantIdIsNullOrZero(tenantId)) {
            tenantId = TenantUtil.TENANT_DEFAULT;
        }
        if (tenantId.equals(TenantUtil.TENANT_DEFAULT)) {
            WechatUserInfo wechatUserInfo = wechatService.findWechatUserInfoByPhoneNo(phoneNo);
            if (wechatUserInfo == null) {
                return JsonResult.buildSuccessResult();
            }
            return JsonResult.buildSuccessResultGeneric(wechatUserInfo.getOpenId());
        }else {
            User user = userService.findByPhoneInDb(phoneNo);
            if (user == null) {
                return JsonResult.buildSuccessResult();
            }
            CustomerInfoEntity tenantCustomerInfo = tenantService.getTenantCustomerInfo(user, tenantId);
            if (tenantCustomerInfo == null) {
                return JsonResult.buildSuccessResult();
            }
            return JsonResult.buildSuccessResultGeneric(tenantCustomerInfo.getSourceOpenId());
        }
    }

    @RequestMapping("/code/{key}/{extdata}")
    public void receiveCode(@PathVariable String key, @PathVariable String extdata) {
        //todo
    }

    @PatchMapping("/forbidden/{userId}")
    public JsonResult forbidden(@PathVariable Long userId, String reason) {
        int res = wechatService.forbiddenUserWeChat(userId);
        log.info("取消微信关联 userId:{},reason:{},结果:{}", userId, reason, res);
        return JsonResult.buildSuccessResultGeneric(res);
    }

    /**
     */
    @PostMapping("/v1/getByOpenIdToUserIds")
    public JsonResult getByOpenIdToUserIds(@RequestBody Map<String, Object> params, @RequestParam(required = false, defaultValue = "wuxi") String appName) {
        log.info("根据userIds获取用户的openId {}, appName:{}", params, appName);
        List<Integer> userIds = (List<Integer>) params.get("userIds");
        if (userIds.isEmpty()) {
            return JsonResult.buildErrorStateResult("用户Id不能为空", null);
        }
        if (userIds.size() > 500) {
            userIds = userIds.subList(0,500);
        }
        List<Long> userIdList = userIds.stream().map(userId -> Long.parseLong(userId.toString())).collect(Collectors.toList());

        List<WechatUserInfo> wechatUserInfoList = wechatService.queryByUserIdsAndAppName(userIdList, appName);
        if (wechatUserInfoList.isEmpty()) {
            return JsonResult.buildSuccessResult();
        }

        return JsonResult.buildSuccessResultGeneric(wechatUserInfoList);

    }
}
