package cn.quantgroup.xyqb.filter;


import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.service.session.ISessionService;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Created by 11 on 2016/12/29.
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE + 100)
public class RequestFilter implements Filter {

  private static final String[] ALLOWED_PATTERNS = {
      "/user_detail/**","/hello/**","/innerapi/**", "/user/exist", "/motan/**", "/user/register", "/user/login", "/user/register/fast",
      "/token/oneTime", "/user/loginForH5", "/user/register/fastForH5",
      "/auth/info/login","/user/login/fast","/user/reset_password", "/user/exist_check","/user/center/**",
      "/jr58/**", "/app/login", "/app/login_super","/app/login2","/user/login2", "/wechat/**", "/config/**", "/api/**", "/user/exists_token","/query/**",
      "/platform/api/page/return_url", "/MP_" +
      "verify_AWiagUn4kZiwmTt0.txt"
  };
  private static final String UNAUTH_RESULT = JSONObject.toJSONString(JsonResult.buildErrorStateResult("登录失败", null));
  @Autowired
  private ISessionService sessionService;
  private AntPathMatcher matcher = new AntPathMatcher();

  @Override
  public void init(FilterConfig filterConfig) throws ServletException {
  }

  @Override
  public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
    HttpServletRequest request = (HttpServletRequest) servletRequest;
    HttpServletResponse response = (HttpServletResponse) servletResponse;
    String requestPath = getRequestPath(request);
    SessionStruct sessionStruct;
    if (!isMatch(requestPath)) {
      //获取session信息,如果没有获取到session信息则返回错误信息
      sessionStruct = XyqbSessionContextHolder.getXSessionFromRedis();
      if (sessionStruct == null) {
        response.setStatus(401);
        response.setHeader("Content-Type", "application/json;charset=utf-8");
        PrintWriter writer = response.getWriter();
        writer.print(UNAUTH_RESULT);
        writer.close();
        return;
      }
      try {
        filterChain.doFilter(request, response);
      } finally {
        sessionStruct = XyqbSessionContextHolder.getXSessionFromRedis();
        if (sessionStruct != null) {
          try {
            sessionService.persistSession(sessionStruct.getSid(), sessionStruct.getValues());
          } finally {
            XyqbSessionContextHolder.releaseSession();
          }
        }
      }
    } else {
      filterChain.doFilter(request, response);
    }

  }

  private boolean isMatch(String path) {
    for (String pattern : ALLOWED_PATTERNS) {
      if (matcher.match(pattern, path)) {
        return true;
      }
    }
    return false;
  }

  private String getRequestPath(HttpServletRequest request) {
    String url = request.getServletPath();

    if (request.getPathInfo() != null) {
      url += request.getPathInfo();
    }
    return url;
  }

  @Override
  public void destroy() {

  }
}
