package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.Address;
import lombok.Data;

import java.io.Serializable;

/**
 * 地址信息数据模型
 *
 * @author renwc
 * @date 2018-01-04
 */
@Data
public class AddressModel implements Serializable {
    private static final long serialVersionUID = -1L;

    private Long provinceCode;
    private String province;
    private Long cityCode;
    private String city;
    private Long districtCode;
    private String district;
    private String address;

    private AddressModel() {
    }

    public static AddressModel entity2Model(Address entity) {
        if (entity == null) {
            return null;
        }
        AddressModel model = new AddressModel();
        model.setProvinceCode(entity.getProvinceCode());
        model.setCityCode(entity.getCityCode());
        model.setDistrictCode(entity.getDistrictCode());
        model.setDistrict(entity.getDistrict());
        model.setProvince(entity.getProvince());
        model.setCity(entity.getCity());
        model.setAddress(entity.getAddress());
        return model;
    }
}
