package cn.quantgroup.xyqb.aspect.log;

import javassist.ClassClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;


/**
 * Created by 11 on 2017/4/20.
 */
@Aspect
@Configuration
public class ParamLogAdvice {

    private Logger LOGGER = LoggerFactory.getLogger(ParamLogAdvice.class);

    /**
     * 定义切面,拦截InnerController类中的所有方法
     */
    @Pointcut("execution(* cn.quantgroup.xyqb.controller.external.user.InnerController.*(..))")
    public void logPointCut(){}

    /**
     * 后置通知,方法执行后获取方法的入参信息并打印日志
     * @param jp
     */
    @After("logPointCut()")
    public void printMethodParam(JoinPoint jp) {
        Object[] params = jp.getArgs();
        String methodName = jp.getSignature().getName();
        String[] paramNames = null;
        try {
            paramNames = getFieldsName(jp.getTarget().getClass(), jp.getTarget().getClass().getName(), methodName);
        } catch (Exception e) {
            e.printStackTrace();
        }
        StringBuffer buffer = new StringBuffer();
        if(null != paramNames) {
            for(int i = 0; i < paramNames.length; i ++) {
                buffer.append(paramNames[i]).append(":").append(params[i]).append(" ");
            }
            String logInfo = buffer.toString().substring(0, buffer.toString().length() - 1);
            LOGGER.info("调用方法,方法名:{} , 方法参数:{}", methodName, logInfo);
        }
    }

    /**
     * 利用javassist获取方法的参数名称
     * @param cls
     * @param clazzName
     * @param methodName
     * @return
     * @throws NotFoundException
     */
    private static String[] getFieldsName(Class cls, String clazzName, String methodName) throws NotFoundException {
        //获取class定义的容器
        ClassPool pool = ClassPool.getDefault();
        ClassClassPath classPath = new ClassClassPath(cls);
        pool.insertClassPath(classPath);
        //从容器中获取编译后的class
        CtClass cc = pool.get(clazzName);
        //反射获取指定方法
        CtMethod cm = cc.getDeclaredMethod(methodName);
        MethodInfo methodInfo = cm.getMethodInfo();

        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        LocalVariableAttribute attr = (LocalVariableAttribute) codeAttribute.getAttribute(LocalVariableAttribute.tag);
        if (attr == null) {
            return null;
        }
        String[] paramNames = new String[cm.getParameterTypes().length];
        int pos = Modifier.isStatic(cm.getModifiers()) ? 0 : 1;
        for (int i = 0; i < paramNames.length; i++){
            paramNames[i] = attr.variableName(i + pos);
        }
        return paramNames;
    }
}
