package cn.quantgroup.xyqb.entity;

import cn.quantgroup.xyqb.config.http.Timestamp2LongConverter;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by Miraculous on 15/7/4.
 */
@Getter
@Setter
@ToString
@Entity
@Table(name = "user", uniqueConstraints = @UniqueConstraint(columnNames = "phone_no"))
public class User implements Serializable {

  private static final long serialVersionUID = -1L;

  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Long id;

  //手机号
  @Column(name = "phone_no")
  private String phoneNo;

  //uuid
  @Column(name = "password")
  private String password;


  //第一次用户来源 channel_id
  @Column(name = "registered_from")
  private Long registeredFrom;

  //uuid
  @Column(name = "uuid")
  private String uuid;

  @Column(name = "enable")
  private Boolean enable;

  //创建时间
  @Column(name = "created_at")
  private Timestamp createdAt;

  //上一次修改时间
  @Column(name = "updated_at")
  @JSONField(serializeUsing = Timestamp2LongConverter.class)
  private Timestamp updatedAt;


}
