package cn.quantgroup.xyqb.controller.middleoffice.userdetail;

import cn.quantgroup.xyqb.controller.middleoffice.userdetail.req.UserDetailReq;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.IdCardInfo;
import cn.quantgroup.xyqb.model.IdType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.auth.IIdCardService;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserService;
import javax.annotation.Resource;
import javax.validation.Valid;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户实名信息
 */
@Slf4j
@RestController("middleUserDetailController")
@RequestMapping("/middle_office/user_detail")
public class UserDetailController {

    @Resource
    private IUserDetailService userDetailService;

    @Resource
    private IUserService userService;

    @Resource
    private IIdCardService idCardService;

    /**
     * 修改用户实名信息
     *
     * @param userId
     * @param userDetailReq
     * @return
     */
    @PutMapping("/{userId}")
    public JsonResult update(@PathVariable Long userId,
                             @Valid @RequestBody UserDetailReq userDetailReq) {
        UserDetail userDetail = userDetailService.findByUserId(userId);
        if (userDetail == null) {
            return save(userId, userDetailReq);
        }
        //更新
        userDetail.setName(userDetailReq.getName());
        userDetail.setIdNo(userDetailReq.getIdNo());
        userDetail = userDetailService.saveUserDetail(userDetail);
        log.info("UserDetailController update, userId:{}, name:{}", userId, userDetailReq.getName());
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

    /**
     * 保存用户实名信息
     *
     * @param userId
     * @param userDetailReq
     * @return
     */
    @PostMapping("/{userId}")
    public JsonResult save(@PathVariable Long userId,
                           @Valid @RequestBody UserDetailReq userDetailReq) {
        UserDetail userDetail = userDetailService.findByUserId(userId);
        if (userDetail != null) {
            return JsonResult.buildSuccessResultGeneric(userDetail);
        }
        User user = userService.findById(userId);
        IdCardInfo idCardInfo = idCardService.getIdCardInfo(userDetailReq.getIdNo());

        userDetail = new UserDetail();
        userDetail.setUserId(userId);
        userDetail.setName(userDetailReq.getName());
        userDetail.setPhoneNo(user.getPhoneNo());
        userDetail.setIdNo(userDetailReq.getIdNo());
        userDetail.setIdType(IdType.ID_CARD);
        userDetail.setGender(idCardInfo.getGender());
        userDetail = userDetailService.saveUserDetail(userDetail);
        log.info("UserDetailController save, userId:{}, phoneNo:{}, name:{}", user.getId(), user.getPhoneNo(), userDetailReq.getName());
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

    /**
     * 根据用户 ID，查询实名信息
     *
     * @param userId
     * @return
     */
    @GetMapping("/userId/{userId}")
    public JsonResult query(@PathVariable Long userId) {
        UserDetail userDetail = userDetailService.findByUserId(userId);
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

    /**
     * 根据手机号，查询实名信息
     *
     * @param phoneNo
     * @return
     */
    @GetMapping("/phoneNo/{phoneNo}")
    public JsonResult query(@PathVariable String phoneNo) {
        UserDetail userDetail = userDetailService.findByPhoneNo(phoneNo);
        return JsonResult.buildSuccessResultGeneric(userDetail);
    }

}
