package cn.quantgroup.xyqb.controller.dust;

import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.entity.UserHashMapping;
import cn.quantgroup.xyqb.model.Gender;
import cn.quantgroup.xyqb.model.IdType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.repository.IUserDetailRepository;
import cn.quantgroup.xyqb.util.encrypt.MD5Util;
import com.google.common.base.Stopwatch;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Slf4j
@RestController
@RequestMapping("/ex/sync_hash")
public class SyncHashController {

    private Boolean isContinue = false;

    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Autowired
    private IUserDetailRepository userDetailRepository;


    /**
     * 发起同步
     *
     * @param startUserId
     * @param step
     * @return
     */
    @GetMapping("/start")
    public JsonResult sync(final Long startUserId, final Long step) {
        isContinue = true;
        executorService
                .execute(() -> {
                    Long startPosition = startUserId;
                    while (isContinue) {
                        Stopwatch started = Stopwatch.createStarted();
                        Long endPosition = startPosition + step;
                        String sql = "select * from `user_detail` u where u.`id_no` like binary '%x' and u.id >= " + startPosition + " and u.id < " + endPosition;
                        List<UserDetail> userDetails = jdbcTemplate.query(sql, (rs, rowNum) -> {
                            UserDetail userDetail = new UserDetail();
                            userDetail.setId(rs.getLong("id"));
                            userDetail.setUserId(rs.getLong("user_id"));
                            userDetail.setPhoneNo(rs.getString("phone_no"));
                            userDetail.setName(rs.getString("name"));
                            userDetail.setIdNo(rs.getString("id_no"));
                            userDetail.setIdType(IdType.values()[rs.getInt("id_type")]);
                            userDetail.setIsAuthenticated(rs.getInt("is_authenticated") == 1);
                            userDetail.setGender(Gender.values()[rs.getInt("gender")]);
                            userDetail.setEmail(rs.getString("email"));
                            userDetail.setQq(rs.getString("qq"));
                            userDetail.setCreatedAt(rs.getTimestamp("created_at"));
                            userDetail.setUpdatedAt(rs.getTimestamp("updated_at"));
                            return userDetail;
                        });
                        if (userDetails.isEmpty()) {
                            startPosition = endPosition;
                            if (endPosition > 49434765L) {
                                log.info("没有数据了. 结束了");
                                return;
                            }
                            continue;
                        }
                        log.info("查询用户需要的时间 : {}ms", started.elapsed(TimeUnit.MILLISECONDS));
                        List<UserHashMapping> userHashMappings = new ArrayList<>();
                        userDetails.forEach(userDetail -> {
                            String idNo = userDetail.getIdNo();
                            if (idNo != null) {
                                userDetail.setIdNo(idNo.toUpperCase());
                                UserHashMapping userHashMapping = new UserHashMapping();
                                userHashMapping.setUserId(userDetail.getUserId());
                                userHashMapping.setIdNoMd5(MD5Util.build(userDetail.getIdNo()));
                                userHashMappings.add(userHashMapping);
                            }
                        });
                        log.info("遍历计算md5&crc32需要的时间 : {}ms", started.elapsed(TimeUnit.MILLISECONDS));
                        started = started.reset().start();

                        StringBuilder sbSql = new StringBuilder("UPDATE `user_hash_mapping` SET `id_no_md5` =  CASE `user_id` ");

                        userHashMappings.forEach(userHashMapping -> sbSql.append(" WHEN ").append(userHashMapping.getUserId()).append(" THEN  '").append(userHashMapping.getIdNoMd5()).append("'"));
                        sbSql.append(" END, `id_no_md5_short` =  CASE `user_id` ");
                        userHashMappings.forEach(userHashMapping -> sbSql.append(" WHEN ").append(userHashMapping.getUserId()).append(" THEN  ").append(userHashMapping.getIdNoMd5Short()));
                        sbSql.append(" END WHERE `user_id`  IN ( ");
                        List<Long> userIds = userHashMappings.stream().map(UserHashMapping::getUserId).collect(Collectors.toList());
                        sbSql.append(StringUtils.collectionToCommaDelimitedString(userIds));
                        sbSql.append(") and `id_no_md5` is null ");

                        jdbcTemplate.execute(sbSql.toString());

                        userDetailRepository.save(userDetails);

                        log.info("batchUpdate需要的时间 : {}ms", started.elapsed(TimeUnit.MILLISECONDS));

                        log.info("来一波,start:{},end:{}", startPosition, endPosition);
                        startPosition = userDetails.get(userDetails.size() - 1).getId() + 1;

                        try {
                            Thread.sleep(250);
                        } catch (InterruptedException e) {
                        }
                    }
                });

        return JsonResult.buildSuccessResult(null);
    }

    /**
     * 暂停同步
     */
    @GetMapping("/stop")
    public JsonResult stop() {
        isContinue = false;
        return JsonResult.buildSuccessResult(null);
    }
}
