package cn.quantgroup.xyqb.entity.middleoffice;

import cn.quantgroup.xyqb.util.ValidationUtil;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/5/27 16:02
 * @description：小程序关联入口参数实体
 * @modified By：
 * @version: 1.0
 */
@Getter
@Setter
public class AppletParamEntry {

    /**
     * 应用标识
     */
    @NotNull(message = "01:appName 不能为空")
    private String appName;
    /**
     * 应用对应的渠道号
     */
    @NotNull(message = "02:channelId 不能为空")
    private Long channelId;
    /**
     * 小程序openid
     */
    @NotNull(message = "03:openId 不能为空")
    private String openId;
    /**
     * 手机号
     */
    @NotNull(message = "04:mobile 不能为空")
    @Pattern(regexp = ValidationUtil.phoneRegExp, message = "手机号格式不对")
    private String mobile;
    /**
     * 用户全局唯一标识
     */
    private String unionId;
    /**
     * 昵称
     */
    private String nickName;
    /**
     * 用户头像
     */
    private String avatarUrl;
    /**
     * 性别1男2女0未知
     */
    private short gender;
    /**
     * 国家
     */
    private String country;
    /**
     * 省份
     */
    private String province;
    /**
     * 城市
     */
    private String city;
    /**
     * 语言
     */
    private String language;
    /**
     * 风控要的字段广告系列来源
     */
    private String utmSource;

    /**
     * 租户ID
     */
    private Integer tenantId;

    /**
     * 小程序编号
     */
    private Integer appNo;
}
