package cn.quantgroup.xyqb.service.applet.impl;

import cn.quantgroup.xyqb.entity.AppletParamEntry;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.WechatUserInfo;
import cn.quantgroup.xyqb.repository.IWeChatUserRepository;
import cn.quantgroup.xyqb.service.applet.IAppletService;
import cn.quantgroup.xyqb.service.register.IUserRegisterService;
import cn.quantgroup.xyqb.service.user.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/5/27 17:27
 * @description：小程序服务层
 * @modified By：
 * @version: 1.0
 */
@Slf4j
@Service
public class AppletServiceImpl implements IAppletService {


    private final IWeChatUserRepository iWeChatUserRepository;

    private final IUserRegisterService iUserRegisterService;

    private final IUserService userService;

    @Autowired
    public AppletServiceImpl(IWeChatUserRepository iWeChatUserRepository, IUserRegisterService iUserRegisterService, IUserService userService) {
        this.iWeChatUserRepository = iWeChatUserRepository;
        this.iUserRegisterService = iUserRegisterService;
        this.userService = userService;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long relevance(AppletParamEntry appletParamEntry) {

        WechatUserInfo wechatUserInfo = iWeChatUserRepository.findByOpenIdAndAppName(appletParamEntry.getOpenId(), appletParamEntry.getAppName());
        //这个接口先不考虑更换手机号的情况只要有userid就直接返回
        if (null != wechatUserInfo && null != wechatUserInfo.getUserId()) {
            return wechatUserInfo.getUserId();
        }

        wechatUserInfo = new WechatUserInfo();
        wechatUserInfo.setNickName(appletParamEntry.getNickName());
        wechatUserInfo.setCity(appletParamEntry.getCity());
        wechatUserInfo.setCountry(appletParamEntry.getCountry());
        wechatUserInfo.setProvince(appletParamEntry.getProvince());
        wechatUserInfo.setAppName(appletParamEntry.getAppName());
        wechatUserInfo.setHeadImgUrl(appletParamEntry.getAvatarUrl());
        wechatUserInfo.setLanguage(appletParamEntry.getLanguage());
        wechatUserInfo.setOpenId(appletParamEntry.getOpenId());
        wechatUserInfo.setSex(appletParamEntry.getGender());
        wechatUserInfo.setUnionId(appletParamEntry.getUnionId());

        User user = userService.findByPhoneInDb(appletParamEntry.getMobile());
        //如果不存在就去注册一下
        if (null == user) {
            user = iUserRegisterService.register(appletParamEntry.getChannelId(), appletParamEntry.getMobile());
        }

        //如果存在就更新在微信表里
        Long id = user.getId();
        wechatUserInfo.setUserId(id);
        wechatUserInfo.setPhoneNo(user.getPhoneNo());
        iWeChatUserRepository.save(wechatUserInfo);
        return id;
    }
}
